#include "mbed.h"
#include "SDFileSystem.h"
 
//Serial pc(USBTX, USBRX);
Serial pc(dp16,dp15);
Ticker timer;
Timer time2 ;

DigitalIn sw(dp17);

int i;//ドリフトを抑えるループの中で使う。

unsigned long beforeTime = 0;
unsigned long elapsedTime = 0;
unsigned long nowTime = 0;
int flagHi = 0 ;
int rpm = 0 ;
double t;
 

//SDFileSystem sd(p5,p6,p7,p8,"sd");//lpc1768用
SDFileSystem sd(dp2,dp1,dp6,dp13,"sd");//lpc1114fn28用

AnalogIn vin (dp9);
AnalogIn hole(dp10);

float v;
float vin_center=0;

FILE* fp;
 
void SD()
{
    
    fprintf(fp,"%f,%d,%.3f,%.3f\n",t,rpm,v,vin_center);
    t += 0.01;
} 
  
int main() {
    
    //==========初期電圧のドリフトを押さえる=========//
         for(i=0;i<10;i++){
             vin_center= vin_center + vin.read()*3.3;
    wait(0.01);
   }
  
     vin_center=vin_center/10.0;
    //==========================================//
    
    
    pc.printf("Start!\n");
   // printf("Start!\n");
    
    time2.start();
    
    
    fp = fopen("/sd/power_meter_data.csv", "w");
    if(fp == NULL) {
        error("Could not open file for write\n");
    }
    
    pc.printf("Start writing!\n");
    
    
   // printf("Start writing!\n");
    
   // void SD_p();
    
    fclose(fp);
    fp = fopen("/sd/power_meter_data.csv", "w");
//    fprintf(fp,"power_meter_data\n");
    fprintf(fp,"t,rpm,v,vin_center\n");
    
    timer.attach(&SD, 0.01);
    while(1){
        
        v=vin.read()*3.3;
        
         //回転数計算
         
        nowTime = time2.read_ms();
        
        if(hole >= 0.5 && flagHi == 0){//パルスHi
         pc.printf("%d\r\n",rpm);
         elapsedTime = nowTime - beforeTime;//前回パルスアップからの経過時間
           rpm = 60000 / elapsedTime ;
    beforeTime = time2.read_ms();//今の時間を記録する
    flagHi = 1;
  }
  if (hole <0.5 && flagHi == 1){//パルスLow
    flagHi = 0;
  }
  if(nowTime - beforeTime>6000){
    elapsedTime=0;
  }//回転数end   
        
        if(sw==1)
        {
            timer.detach();
            break;
            }
    }//while end
    
    fclose(fp);
   // printf("Finish!!\n");
    //printf("Pased time %.2f\n",t);
    pc.printf("Finish!!\n");
    pc.printf("Pased time %.2f\n",t);
    
}