#include "Vector_Matrix_operator.h"

Vector operator*(const Matrix& lhm, const Vector& rhv) {
    if (lhm.GetCol() != rhv.GetDim()) error("Irregular Dimention");
    Vector retVec(lhm.GetRow());

    for (int i = 1; i <= lhm.GetRow(); i++) {
        float temp = 0.0f;
        for (int j = 1; j <= rhv.GetDim(); j++) {
            temp += lhm.GetComp(i, j)*rhv.GetComp(j);
        }
        retVec.SetComp(i, temp);
    }

    retVec.CleanUp();

    return retVec;
}

Vector operator*(const Vector& lhv, const Matrix& rhm) {
    if (lhv.GetDim() != rhm.GetRow()) error("Irregular Dimention");
    Vector retVec(rhm.GetCol());

    for (int i = 1; i <= rhm.GetCol(); i++) {
        float temp = 0.0f;
        for (int j = 1; j <= lhv.GetDim(); j++) {
            temp += lhv.GetComp(j) * rhm.GetComp(j, i);
        }
        retVec.SetComp(i, temp);
    }

    retVec.CleanUp();

    return retVec;
}