
class MG354PDH0 {
    
public: 
    MG354PDH0(Serial* ps);

    void call_window1();
    void call_window0();
    void GLOB_CMD_read();
    void DIAG_STAT_read();
    void UART_CTRL_write();
    /*サンプリングモードへの移行*/
    void move_to_sampling_mode();
    /*IMUが動作可能かどうかの確認*/
    void power_on_sequence1();
    /*IMUが動作可能かどうかの確認*/
    void power_on_sequence2();
    
    /*X軸周りの角速度を算出*/
    float read_angular_rate_x();
    /*Y軸周りの角速度を算出*/
    float read_angular_rate_y();
    /*Z軸周りの角速度を算出*/
    float read_angular_rate_z();
    
    /*X軸の加速度を算出*/
    float read_acceleration_x();
    /*Y軸の加速度を算出*/
    float read_acceleration_y();
    /*Z軸の加速度を算出*/
    float read_acceleration_z();
        
    float gyro_val[3];//角速度の値
    float acc_val[3];//加速度の値
     
    
private: 
    Serial* p_port;
    
    #define SCALE_FACTOR_GYRO 0.016
    #define SCALE_FACTOR_ACC 0.20
    #define GRAVITIONAL_ACCELERATION 9.80665

    char val_GLOB_CMD_read[2];
    short i_GLOB_CMD_read;
    
    char val_DIAG_STAT_read[2];
    short i_DIAG_STAT_read;
    
    char val_rate_x[4];
    char val_rate_y[4];
    char val_rate_z[4];
    
    char val_acc_x[4];
    char val_acc_y[4];
    char val_acc_z[4];
    
    float gyro_x,gyro_y,gyro_z;
    float acceleration_x,acceleration_y,acceleration_z;
    
};