
//GPS GT-720F Logger01

#include "mbed.h"
#include "SDFileSystem.h"
#define ON 1
#define OFF 0

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);
DigitalIn sw1(p5);

SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board
FILE *fp;//ポインタ指定

Serial gps(p9,p10); 

Ticker flipper;

float g_hokui,g_tokei;
int fp_count=0;

void gps_rec() {
   
   fp = fopen("/sd/nmea.csv", "w");
        if(fp == NULL) {
        error("Could not open file for write\n");
        }
    fprintf(fp,"%4.6f,%3.6f,\n",g_tokei,g_hokui);
     fclose(fp);                        
}

int main() {
    

      char c;
      int i,rlock=0,stn=0;
      char gps_data[256];
      char ns,ew;
      float time,hokui,tokei;
 
      float d_hokui,m_hokui,d_tokei,m_tokei;
      int h_time=0,m_time=0,s_time=0;
      int rec_flag=0;
      
      gps.baud(9600);//GT-720Fボーレート
      
 
      
    while (1) {
            
      i=0;
      while(gps.getc()!='$'){
      }
      
      while( (gps_data[i]=gps.getc()) != '\r'){
        i++;
        if(i==256){//上限文字数250文字
           i=255;
           break;
         }
      }
      gps_data[i]='\0';
      
      //test
      /* Test data
       rlock=1;
       stn=3;
       hokui=3532.25024; //=>35.537502
       tokei=13751.86820;//=>137.864471
       time=114107.046;
      */  
      
      //正常に作動
      //GPGGAセンテンスを見つける
      if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&time,&hokui,&ns,&tokei,&ew,&rlock,&stn) >= 1){
        if(rlock >= 1){//衛星ロック、緯度経度計測開始

        //hokui　北緯の処理
        
          d_hokui=int(hokui/100);
          m_hokui=(hokui-d_hokui*100)/60;
          g_hokui=d_hokui+m_hokui;
         //tokei 東経の処理
         
          d_tokei=int(tokei/100);
          m_tokei=(tokei-d_tokei*100)/60;
          g_tokei=d_tokei+m_tokei;
         //g_hokui=int(hokui/100)+(hokui-int(hokui/100))/60;
         //g_tokei=int(tokei/100)+(tokei-int(tokei/100))/60;
          
         //time set
          h_time=int(time/10000);
          m_time=int((time-h_time*10000)/100);
          s_time=int(time-h_time*10000-m_time*100);
          h_time=h_time+9;//UTC =>JST
          
     
           flipper.attach(&gps_rec, 1.0);//ロギング割り込み開始
           
        }//if(rclock>1)

        }//if sscanf
    }//while
}//main


