//==================================================
//Servo 
//
//MPU board: mbed LPC1768
//2019/11/17 A.Toda
//==================================================
#include "mbed.h"

//==================================================
#define SERVO_PERIOD  0.020
//==================================================

//Port Setting

PwmOut ELE(p21);
Serial pc(USBTX, USBRX);    //UART

//==================================================
//Timer valiables
//==================================================

double pulse_width_ele;

//==================================================
//Main
//==================================================
int main() {

    //UART initialization
    pc.baud(115200);
    
    //define servo period
    ELE.period(SERVO_PERIOD);  // servo requires 20ms period
    pulse_width_ele=0.6/1000.0;
    
    //while
    while(1) {
                
        // servo position determined by a pulsewidth between 0.6-2.4ms
        
        for(int i=0;i<18;i++){
            pulse_width_ele += ( 0.1/1000.0 );
            ELE.pulsewidth(pulse_width_ele);
            pc.printf("Pulse width is %f\r\n",pulse_width_ele);
            wait(1.0);
            }
        
        pulse_width_ele=0.6/1000.0;
        
    }//while ends
    
}//main ends