//==================================================
//Reading PWM pulse
//
//MPU board: mbed LPC1768
//2019/10/13 A.Toda
//==================================================
#include "mbed.h"

//Port Setting
InterruptIn reading_port(p15); 
Serial pc(USBTX, USBRX);    //UART

//==================================================
//Timer valiables
//==================================================
Timer ch_time;//timer for calculate pulse width

double measured_pre_pulse=0.0;
double measured_pulse=0.0;

//=================================================
//Functions for rising and falind edge interrution
//=================================================
//rise edge
void rising_edge(){
    ch_time.reset();//reset timer counter
    measured_pre_pulse=ch_time.read();
    
}

//falling edge
void falling_edge(){
    measured_pre_pulse=(ch_time.read()-measured_pre_pulse);
    pc.printf("The pulse width=%f\r\n",measured_pre_pulse);
}

//==================================================
//Main
//==================================================
int main() {

    //UART initialization
    pc.baud(115200);
    
    //Logging starts
    pc.printf("Reading starts.");
    
    //timer starts
    ch_time.start();
    
    //declare interrupitons
    reading_port.rise(rising_edge);
    reading_port.fall(falling_edge);
    
    //while
    while(1) {
        wait(0.01);
    }//while ends
    
}//main ends