//==================================================
//Manual and Auto
//
//MPU board: mbed LPC1768
//Multiplexer TC74HC157AP
//2019/10/13 A.Toda
//==================================================
#include "mbed.h"

//==================================================
#define THRESHOLD_PWM 0.0015
#define SERVO_PERIOD  0.020
//==================================================

//Port Setting
InterruptIn reading_port(p18); 
DigitalOut mux_switch(p19);
PwmOut ELE(p21);
Serial pc(USBTX, USBRX);    //UART

//==================================================
//Timer valiables
//==================================================
Timer ch_time;//timer for calculate pulse width

double measured_pre_pulse=0.0;
double measured_pulse=0.0;

double pulse_width_ele;
//=================================================
//Functions for rising and falind edge interrution
//=================================================
//rise edge
void rising_edge(){
    ch_time.reset();//reset timer counter
    measured_pre_pulse=ch_time.read();
    
}

//falling edge
void falling_edge(){
    measured_pre_pulse=(ch_time.read()-measured_pre_pulse);
    pc.printf("The pulse width=%f\r\n",measured_pre_pulse);
    if(measured_pre_pulse>THRESHOLD_PWM){
        mux_switch=1;
        }else{
            mux_switch=0;
            }
}

//==================================================
//Main
//==================================================
int main() {

    //UART initialization
    pc.baud(115200);
    
    //Logging starts
    pc.printf("Reading starts.");
    
    //define servo period
    ELE.period(SERVO_PERIOD);  // servo requires a 20ms period
    pulse_width_ele=0.001;
    
    //timer starts
    ch_time.start();
    
    //declare interrupitons
    reading_port.rise(rising_edge);
    reading_port.fall(falling_edge);
    
    mux_switch=0;
    
    //while
    while(1) {
                
        pulse_width_ele=0.0015;
        wait(0.05);
    }//while ends
    
}//main ends