//GPS GT-720F Test05
#include "mbed.h"

#include "SDFileSystem.h"

#define ON 1
#define OFF 0
Serial gps(p9,p10);// tx, rx 

LocalFileSystem local("local");

DigitalOut mled0(LED1);
DigitalOut mled1(LED2);

SDFileSystem    sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board


Serial pc(USBTX, USBRX); // tx, rx 

FILE *fp;

int main() {

      char c;
      int i,rlock,stn;
      char gps_data[256];
      char ns,ew;
      float time,hokui,tokei;
      float g_hokui,g_tokei;
      float d_hokui,m_hokui,d_tokei,m_tokei;
 
      int h_time=0,m_time=0,s_time=0;
      
 mkdir("/sd/gps_data", 0777);//まずsdのフォルダをつくる。
 
      gps.baud(9600);

    while (1) {
      i=0;
      while(gps.getc()!='$'){
      }
      
      while( (gps_data[i]=gps.getc()) != '\r'){
        i++;
        if(i==256){
         
           i=255;
           break;
         }
      }
      gps_data[i]='\0';
      
      //test
      /* Test data
       rlock=1;
       hokui=3532.25024; //=>35.537502
       tokei=13751.86820;//=>137.864471
      */  
      if( sscanf(gps_data, "GPGGA,%f,%f,%c,%f,%c,%d,%d",&time,&hokui,&ns,&tokei,&ew,&rlock,&stn) >= 1){
        if(rlock >= 1){
          
          //time set
          h_time=int(time/10000);
          m_time=int((time-h_time*10000)/100);
          s_time=int(time-h_time*10000-m_time*100);
          h_time=h_time+9;//UTC =>JST
          
          //hokui
          d_hokui=int(hokui/100);
          m_hokui=(hokui-d_hokui*100)/60;
          g_hokui=d_hokui+m_hokui;
          //tokei
          d_tokei=int(tokei/100);
          m_tokei=(tokei-d_tokei*100)/60;
          g_tokei=d_tokei+m_tokei;
          //g_hokui=int(hokui/100)+(hokui-int(hokui/100))/60;
          //g_tokei=int(tokei/100)+(tokei-int(tokei/100))/60;
        
          
          //==================================================//
         
         pc.printf("%2d,%2d,%2d,%4.6f,,%3.6f,\r\n",h_time,m_time,s_time,g_tokei,g_hokui);
         
         fp = fopen("/sd/gps_data/log.txt", "a");
    
        //  fprintf(fp,"%2d,%2d,%2d,%4.6f,,%3.6f,\r\n",h_time,m_time,s_time,g_tokei,g_hokui);
        fprintf(fp,"%4.6f,%3.6f,\r\n",g_tokei,g_hokui);
          fclose(fp);
          
          //==================================================//
          
          
         
        //}
        }
      }//if
    }//while
}//main



