/* 
ELEC2645 Embedded Systems Project
School of Electronic & Electrical Engineering
University of Leeds
2019/20

Name: Joe Shotton
Username: ll16j23s
Student ID Number: 201127267
Date: 4/4/20
*/

// includes
#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "FXOS8700CQ.h"
#include "SnakeEngine.h"
#include <vector>
#include <cstdlib>

#define X_MAX       84
#define Y_MAX       48

// objects
Gamepad pad;
N5110 lcd;
SnakeEngine snake;
FXOS8700CQ mag(I2C_SDA,I2C_SCL);

int main() {
    
    lcd.init(); //initialise the screen 
    pad.init(); //initialise the gamepad 
    
    snake.game_state = 1;
    snake.menu1_init(pad, lcd);

    while(1) {
        
        while(snake.game_state == 1){ //menu 1
            snake.menu1_select(pad, lcd, mag); //run menu 1 controls
            snake.contrast(pad, lcd);  //set contrast with pot2
        }
    
        while(snake.game_state == 2){ //menu 2
            snake.menu2_select(pad, lcd, mag); //run menu 2 controls
            snake.contrast(pad, lcd);  //set contrast with pot2
        }
    
        while(snake.game_state == 3){ //game
            lcd.clear();               //reset the screen buffer
            snake.game_run(pad, lcd);  //run the game
            lcd.refresh();             //refresh the screen with the updated buffer
            wait_ms(500/(5+snake.score)); //wait time is a function of the score
        }
    
        while(snake.game_state == 4){ //death menu
            snake.death_select(pad, lcd, mag); //run death menu controls
            snake.contrast(pad, lcd);  //set contrast with pot2
        }
    }
}