#ifndef SNAKEENGINE_H
#define SNAKEENGINE_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "FXOS8700CQ.h"
#include "SnakeBody.h"
#include "Food.h"
#include <vector>

/** SnakeEngine Class
@author Joseph Shotton
@brief  Engine that controls the mechanics of the snake game
@date May 2020
@version V1.0
*/ 

class SnakeEngine
{

public:
    SnakeEngine();
    ~SnakeEngine();
    
    
    /** Initialises menu 1
    *@param Gamepad
    *@paran LCD
    */
    void menu1_init(Gamepad &pad, N5110 &lcd);
    
    
    /** Controls selection of options in menu 1
    *@param Gamepad
    *@param LCD
    *@param Magnometer
    */
    void menu1_select(Gamepad &pad, N5110 &lcd, FXOS8700CQ &mag);


    /** Controls selection of options in menu 2
    *@param Gamepad
    *@param LCD
    *@param Magnometer
    */
    void menu2_select(Gamepad &pad, N5110 &lcd, FXOS8700CQ &mag);


    /** Runs game 
    *@param Gamepad
    *@param LCD
    */
    void game_run(Gamepad &pad, N5110 &lcd);
    
    
    /** Controls selection of options in death menu
    *@param Gamepad
    *@param LCD
    *@param Magnometer
    */
    void death_select(Gamepad &pad, N5110 &lcd, FXOS8700CQ &mag);
    
    
    /** Reads pot2 and controls contrast accordingly
    *@param Gamepad
    *@param LCD
    */
    void contrast(Gamepad &pad, N5110 &lcd_);
    
    int score;
    int game_state;
    

private:

    SnakeBody _body;
    Food _food;
    
//  game functions and variables
    
    
    /** Initialises the game
    *@param Gamepad
    *@param LCD
    *@param Magnometer
    */
    void game_init(Gamepad &pad, N5110 &lcd, FXOS8700CQ &mag);
    
    
    /** Detects snake-food collisions and controls respawning of food/length increase etc
    *@param Gamepad
    *@param LCD
    */
    void snake_food_collision(Gamepad &pad, N5110 &lcd);
    
    
    /** Controls correct map to be displayed and correct snake-map collision functions
    *@param LCD
    */
    void map_run(N5110 &lcd);
    
    
     /** Draws map 2 (Ring)
    *@param LCD
    */
    void map2_draw(N5110 &lcd);
    
    
     /** Draws map 3 (Cross)
    *@param LCD
    */
    void map3_draw(N5110 &lcd);
    
    
     /** Draws map 4 (Lanes)
    *@param LCD
    */
    void map4_draw(N5110 &lcd);
    
    
     /** Detects snake-map collision on map 2
    */
    void snake_map2_collision();
    
    
     /** Detects snake-map collision on map 3
    */
    void snake_map3_collision();
    
    
     /** Detects snake-map collision on map 4
    */
    void snake_map4_collision();
    
    bool _death;
    int _map4_location; 
    float _angle;  
    
//  menu/transition functions and variables

    /** Initialises menu 2
    *@param Gamepad
    *@param LCD
    */
    void menu2_init(Gamepad &pad, N5110 &lcd);
    
    
    /** Initialises death menu
    *@param Gamepad
    *@param LCD
    */
    void death_init(Gamepad &pad, N5110 &lcd);
    
    
    /** Creates black transition animation
    *@param LCD
    */
    void transition_black(N5110 &lcd);
        
    
    /** Creates white transition animation
    *@param LCD
    */
    void transition_white(N5110 &lcd);
    
    
    /** Draws black circle on selected line and clears other lines' circles
    *@param LCD
    *@param Line that current option will be selected on. Range 1 - 5  
    */
    void select_circles(N5110 &lcd, int line);
    
    
    /** Generates short preview of selected map, then reinitialises menu 2
    *@param Gamepad
    *@param LCD
    */
    void preview(Gamepad &pad, N5110 &lcd);
    
    
    /** Resets relevant variables so game can be replayed
    */
    void game_reset();
    
    /** Triple flashes LEDs
    *@param Gamepad
    *@param Led numbers - will trigger both sides (ie both red LEDs). Range 1 - 3
    */
    void menu_flash(Gamepad &pad, int led);
     
    int _menu_select; 
    int _map_select;
    double _pot2;

};

#endif