#ifndef FOOD_H
#define FOOD_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "FXOS8700CQ.h"

/** SnakeEngine Class
@author Joseph Shotton
@brief  All functions that exclusively control the food
@date May 2020
@version V1.0
*/ 

class Food
{
    
public:

    Food();
    ~Food();
    
    
    /** Initialises magnetometer and seeds random function
    *@param Gamepad
    *@param LCD
    *@param Magnetometer
    */
    void init(Gamepad &pad, N5110 &lcd, FXOS8700CQ &mag);
    
    
    /** Chooses random coordinates for food
    *@param Gamepad
    *@param LCD
    *@returns returns true if selected position is already on (ie the snake or walls are at this coordinate)
    */
    bool rand_pos(Gamepad &pad, N5110 &lcd);
    
    
    /** Animates food
    *@param LCD
    */
    void draw(N5110 &lcd);
    
    
    /** Runs food functions that need looping
    *@param LCD
    */
    void run(N5110 &lcd);
    
    int _x;
    int _y;
    
private:
    int _frame;
    float _values;
    float _seed;
};
#endif