#include "Food.h"

Food::Food()
{
//constructor
    _x = 22; // starts off-screen
    _y = 30;
    _frame = 0; 
}

Food::~Food()
{
//deconstructor
}

void Food::init(Gamepad &pad, N5110 &lcd, FXOS8700CQ &mag) {
    
    mag.init();
    Data _values = mag.get_values();
    _seed = 1000000*(_values.mx + _values.my + _values.mz); //seed generated from combination of accelerometre values so any can change for seed to change
    srand(_seed);
    while (rand_pos(pad, lcd) == false){ //while new food coordinates are in the snake/walls
        rand_pos(pad, lcd);              //choose new coords by rerunning the function
        printf("Reselected food position\n");
    }
}


bool Food::rand_pos(Gamepad &pad, N5110 &lcd) {
    wait_ms(10);
    pad.led(3,0.1);
    _x = 2 * (rand() % 42); //selects random x cell 
    //printf("Food x: %d\n", _x);
    _y = 2 * (rand() % 24); //selects random y call
    //printf("Food y: %d\n", _y);
    if (lcd.getPixel(_x,_y)) { //checks if selected pixel is already black (ie body or walls at this location)
        return false;
    } else {
        return true;
    } 
}

void Food::draw(N5110 &lcd, int &_frame) {
    
    // draw food, with alternating pixels depending on frame. 
    _frame++;
    _frame = _frame % 12;
    if (_frame > 6) { 
        lcd.drawLine(_x, _y, _x + 1,_y + 1,1);
    } else {
        lcd.drawLine(_x + 1, _y, _x,_y + 1,1);
    }
}

void Food::run(N5110 &lcd)
{
     draw(lcd, _frame);
}

