#include "stdio.h"
#include "mbed.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
#include "SDFileSystem.h"

InterruptIn BPlus(p21);
InterruptIn BMoins(p22);    // Déclaration des Boutons poussoirs
InterruptIn BValide(p23);

char PosMenu;               // Déclaration des menus
bool MenuPrincipal;
bool ecrire;
Ticker heure;
int flip = 0;

// Pin de connection de l'écran TFT
SPI_TFT_ILI9341 TFT(p11, p12, p13, p5, p7, p6,"TFT"); //mosi,miso,sclk,cs,reset,dc

void attime()
{
    flip = !flip;
}
void trigger1()     //Bouton poussoir de gauche
{
    ecrire=0;
    if(MenuPrincipal==0) {
        if(PosMenu>0) {
            PosMenu=PosMenu-1;
            wait_ms(75);
        }
    }
}
void trigger2()     //Bouton poussoir du milieu
{
    ecrire=0;
    if(MenuPrincipal==0) {
        if(PosMenu<=1) {
            PosMenu=PosMenu+1;
            wait_ms(75);
        }
    }
}
void trigger3()     //Bouton poussoir de droite
{
    ecrire=0;
    if(MenuPrincipal==0) {
        MenuPrincipal=1;
    } else {
        MenuPrincipal=0;
        wait_ms(75);
    }
}
int main ()
{
    heure.attach(&attime, 10);
    MenuPrincipal=0;
    PosMenu=0;
    BPlus.rise(&trigger1);
    BMoins.rise(&trigger2);
    BValide.rise(&trigger3);
    set_time(456771);
    TFT.claim(stdout);
    TFT.set_orientation(3);
    TFT.background(White);    // Applique le fond de l'écran en blanc
    TFT.foreground(Black);    // Applique la police de caractère en noir
    TFT.cls();                // Réinitialise l'écran
    TFT.set_font((unsigned char*) Neu42x35);
    TFT.locate(12,1);
    TFT.printf("MENU");
    TFT.rect(5,40,826,85,Black);        // Rectangles
    TFT.rect(5,90,826,135,Black);
    TFT.rect(5,140,826,185,Black);
    TFT.rect(5,190,826,235,Black);
    while(1) {

        if(flip == 0) {
            TFT.set_font((unsigned char*) Arial28x28);
            TFT.locate(220,10);
            time_t heure=time(NULL);
            char buffer[32];
            strftime(buffer,32,"%Hh%M",localtime(&heure));
            TFT.printf("%s",buffer);
        }
        TFT.set_font((unsigned char*) Neu42x35);
        if(ecrire==0) {
            if(MenuPrincipal==0) {
                if(PosMenu==0) {             //Sélection sur CAPTEURS
                    TFT.foreground(Red);
                    TFT.locate(12,45);
                    TFT.printf("Capteurs   ");
                    TFT.foreground(Black);
                    TFT.locate(12,95);
                    TFT.printf("Mesures    ");
                    TFT.foreground(Black);
                    TFT.locate(12,145);
                    TFT.printf("Horloge    ");
                    TFT.locate(12,195);
                    TFT.printf("          ");
                }
                if(PosMenu==1) {            //Sélection sur MESURES
                    TFT.foreground(Black);
                    TFT.locate(12,45);
                    TFT.printf("Capteurs   ");
                    TFT.foreground(Red);
                    TFT.locate(12,95);
                    TFT.printf("Mesures   ");
                    TFT.foreground(Black);
                    TFT.locate(12,145);
                    TFT.printf("Horloge     ");
                    TFT.locate(12,195);
                    TFT.printf("          ");
                }
                if(PosMenu==2) {            //Sélection sur HORLOGE
                    TFT.foreground(Black);
                    TFT.locate(12,45);
                    TFT.printf("Capteurs   ");
                    TFT.foreground(Black);
                    TFT.locate(12,95);
                    TFT.printf("Mesures    ");
                    TFT.foreground(Red);
                    TFT.locate(12,145);
                    TFT.printf("Horloge     ");
                    TFT.foreground(Black);
                    TFT.locate(12,195);
                    TFT.printf("          ");
                }
            } else {
                if(PosMenu==0) {            //Sous menu de CAPTEURS
                    TFT.set_font((unsigned char*) Neu42x35);
                    TFT.foreground(Black);
                    TFT.locate(12,45);
                    TFT.printf("C1   ");
                    TFT.locate(109,45);
                    TFT.printf("C2   ");
                    TFT.locate(220,45);
                    TFT.printf("C3");
                    TFT.locate(12,95);
                    TFT.printf("C4   ");
                    TFT.locate(109,95);
                    TFT.printf("C5   ");
                    TFT.locate(220,95);
                    TFT.printf("C6");
                    TFT.locate(12,145);
                    TFT.printf("C7   ");
                    TFT.locate(109,145);
                    TFT.printf("C8   ");
                    TFT.locate(220,145);
                    TFT.printf("C9");
                    TFT.locate(12,195);
                    TFT.printf("C10");
                }
                if(PosMenu==1) {            //Sous menu de MESURES
                    TFT.foreground(Black);
                    TFT.locate(12,45);
                    TFT.printf("Temp :   ");
                    TFT.foreground(Black);
                    TFT.locate(12,95);
                    TFT.printf("Forces :    ");
                    TFT.foreground(Black);
                    TFT.locate(12,145);
                    TFT.printf("         ");
                }
                if(PosMenu==2) {            //Sous menu d'HORLOGE
                    TFT.foreground(Black);
                    TFT.locate(12,45);
                    TFT.printf("Reglages Clk");
                    TFT.foreground(Black);
                    TFT.locate(12,95);
                    TFT.printf("       ");
                    TFT.foreground(Black);
                    TFT.locate(12,145);
                    TFT.printf("         ");
                }
            }
        }
        ecrire=1;
    }
}