#include "mbed.h"
#include "const.h"
#include "Robot.h"

DigitalOut myled(LED1);
Robot bertl;

void Forwaerts()
{
    bertl.Move();
}    

void Links_Drehung()
{
    bertl.TurnLeft();
}

void Knabber_LEDs(int a)
{
    bertl.NibbleLeds(a);
}

void LED_AN(int16_t led)
{
    bertl.TurnLedOn(led);
}

void LED_AUS(int16_t led)
{
    bertl.TurnLedOff(led);
} 

void Bunte_LEDs(bool rot, bool gruen, bool blau)
{
    bertl.RGBLed(rot,gruen,blau);
}

void LEDs_Blau_AN()
{
    bertl.BlueLedsON();
}

void LEDs_Blau_Aus()
{
    bertl.BlueLedsOFF();
}

void Warten_Auf_Knopfdruck()
{
    bertl.WaitUntilButtonPressed();
}

void Vorne_Frei()
{
    bertl.FrontIsClear();
}

void Neben_Beeper ()
{
    bertl.NextToABeeper();
}

void Ist_Knopf_Gedrueckt (const int btn)
{
    bertl.IsButtonPressed(btn);
}

void Knopfdruck_zurueckgeben()
{
    bertl.ReturnButtonPressed();
}

// JUST FOR FUN

int main(){}       