// N.C. Freertos mbed minimal example based on below:
// https://developer.mbed.org/users/rgrover1/code/FreeRTOS/
// http://www.radekdostal.com/content/freertos-610-minimal-example

#include "mbed.h"
#include "FreeRTOS.h"
#include "task.h"
#include "m3pi.h"

m3pi m3pi;

DigitalOut led1(LED1);
DigitalOut led2(LED2);

DigitalOut nRST(p26);

const portTickType xDelay = 100 / portTICK_RATE_MS;

const float fVref = 4.0;


void TaskBluetooth (void* pvParameters)
{       
    (void) pvParameters;                    // Just to stop compiler warnings.   
        
    int i;    
    
    nRST = 0;
    vTaskDelay(xDelay);
    nRST = 1;
    
    Serial rn41(p28,p27); // Serial rn41(p9,p10);
    
    rn41.baud(115200);
    led1 = 1;
    led2 = 1;   
    
    for (;;) {
        
        if(m3pi.battery() < fVref) {
            m3pi.cls();
            m3pi.locate(0,0);
            m3pi.print("Low Pwr!", 8);            
        }        
        else{
            m3pi.cls();
            m3pi.locate(0,0);
            m3pi.print("BT Task", 8);
        }
         
        if (rn41.readable()) {          // When BT is readable
        
            i = rn41.getc();            // Reads Bluetooth
            led2 = i;                   // The received[0 / 1] turns [off / on] LED2
            
            if(rn41.writeable()) {
                rn41.putc(led2);        // Send LED2 state to the BT terminal
            }
            
        } 
            
        led1 = !led1;
        vTaskDelay(xDelay);
    }
}



int main (void)
{
    xTaskCreate( TaskBluetooth, ( const char * ) "TaskBluetooth", configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY, ( xTaskHandle * ) NULL );
    vTaskStartScheduler();
   //should never get here
   printf("ERORR: vTaskStartScheduler returned!");
   for (;;);
}