// N.C. Freertos mbed minimal example based on below:
// https://developer.mbed.org/users/rgrover1/code/FreeRTOS/
// http://www.radekdostal.com/content/freertos-610-minimal-example

#include "mbed.h"
#include "FreeRTOS.h"
#include "task.h"
#include "m3pi.h"

m3pi m3pi;

DigitalOut led1(LED1);
DigitalOut led2(LED2);

Serial rn41(p28,p27); // Serial rn41(p9,p10);


const portTickType xDelay = 100 / portTICK_RATE_MS;

const float fVref = 4.0;


void TaskBluetooth (void* pvParameters)
{       
    (void) pvParameters;                    // Just to stop compiler warnings.   
    
    char *cBufferBT;    
    
    rn41.baud(115200);
    led1 = 1;
    led2 = 1;   
    
    for (;;) {
        
        if(m3pi.battery() < fVref) {
            m3pi.cls();
            m3pi.locate(0,0);
            m3pi.print("Low Pwr!", 8);            
        }        
        else{
            m3pi.cls();
            m3pi.locate(0,0);
            m3pi.print("BT Task", 8);
        }
         
        if (rn41.readable()) {          // When BT is readable
        
            sprintf(cBufferBT, "%d", rn41.getc());    // Reads Bluetooth
            m3pi.locate(0,1);           // Prints the received message on the LCD
            m3pi.print(cBufferBT, 8);
            
            rn41.putc(6);   // Send message to the BT terminal
            led2 = !led2;
        } 
            
        led1 = !led1;
        vTaskDelay(xDelay);
    }
}



int main (void)
{
    xTaskCreate( TaskBluetooth, ( signed char * ) "TaskBluetooth", configMINIMAL_STACK_SIZE, NULL, tskIDLE_PRIORITY, ( xTaskHandle * ) NULL );
    vTaskStartScheduler();
   //should never get here
   printf("ERORR: vTaskStartScheduler returned!");
   for (;;);
}