#include "mbed.h"
#include "TextLCD.h"

//ENTRADAS Y SALIDAS
DigitalIn PULS_SUMA(PTC17);
DigitalIn PULS_RESTA(PTC6);
DigitalIn PULS_MODO(PTC12);
DigitalIn PULS_ENCENDIDO(PTC16);
DigitalOut ROJO(LED1);
DigitalOut AZUL(LED3);
TextLCD lcd(PTC7,PTB1,PTB2,PTB3,PTC2,PTC1, TextLCD::LCD20x4); // rs, e, d4-d7
AnalogIn ADC(PTB0);

//ENUMS MAQUINA AIRE //
enum {APAGADO, ESPERA_CALOR, CALOR , FRIO, ESPERA_FRIO,NO_GIRA,IZQUIERDA
     };

// ENUMS MAQUINA ANTIRREBOTE //
enum {
    SUELTO, QUIZAS_PRESIONADO, PRESIONADO, QUIZAS_SUELTO
};


//ENUMS MAQUINA DETECTOR DE FLANCOS //
enum {
    NO_PRESIONADO, APRETADO, DEJO_APRETAR
};

//OBJETOS //
Ticker temporizador;
Ticker med;

//PROTOCOLOS //
void AIRE_Control(int pulsa);
int PULS_Antirrebote(void);
int DETECTOR_Flancos(int maq_antirrebote);
void Set_tempe(int m);
void timer (void);
void Medicion_tempe(void);
void Manejo_display(int pul);

//VARIABLES
unsigned char AIRE_estado = APAGADO;
unsigned char DETECTOR_estado = NO_PRESIONADO;
unsigned char PULS_estado = SUELTO;
int a = 0;
int b = 0;
int timeout = 0;
int tempe_medida_anterior = 0;
int tempe_medida = 0;
int tempe_set = 20;          
int modo = 0;       // Variable utilizada en maquina AIRE_Control //
int pulsador =0 ;   // Variable usada para maquina PULS_Antirrebote //
int p =0;           // Variable devuelta por maquina PULS_Antirrebote //
int puls=0 ;        // Variable devuelta por maquina DETECTOR_Flancos //
int y = 0;          // Variable utilizada en funcion manejo_display //

//MAIN
int main()
{
    ROJO = 1;   // Led rojo apagado //
    AZUL = 1;   // Led azul apagado //
    temporizador.attach(&timer,0.001);
    med.attach(&Medicion_tempe, 1);

    while(1) {
        a = PULS_Antirrebote();
        b = DETECTOR_Flancos(a);
        AIRE_Control(b);
        if(y == 1) {
            Set_tempe(b);
        }

        tempe_medida = (ADC*30);

        Manejo_display(b);
    }
}

void AIRE_Control (int pulsa)    // Maneja los estados del Aire //
{
    switch (AIRE_estado) {
        case APAGADO:
            if(pulsa == 4) {
                AIRE_estado=FRIO;
            }
            AZUL = 1; // Led azul apagado //
            ROJO = 1; // Led rojo apagado //
            modo = 0;
            break;

        case FRIO:
            if(pulsa == 4) {
                AIRE_estado = APAGADO;
            }
            if(pulsa == 3) {
                AIRE_estado = CALOR;
            }
            if(tempe_medida <= tempe_set) {
                AIRE_estado = ESPERA_FRIO;
            }
            AZUL = 0;   // Led azul prendido //
            ROJO = 1;   // Led rojo apagado //
            modo = 1;
            break;

        case CALOR:
            if(pulsa == 4) {
                AIRE_estado = APAGADO;
            }
            if(pulsa == 3) {
                AIRE_estado = FRIO;
            }
            if(tempe_medida >= tempe_set) {
                AIRE_estado = ESPERA_CALOR;
            }
            AZUL = 1;   // Led azul apagado // 
            ROJO = 0;   // Led rojo prendido //
            modo = 2;
            break;
        case ESPERA_CALOR:
            if(tempe_medida == (tempe_set-2)) {
                AIRE_estado = CALOR;
            }
            if(pulsa == 4) {
                AIRE_estado=APAGADO;
            }
            if(pulsa == 3) {
                AIRE_estado = FRIO;
            }
            AZUL = 1;   // Led azul apagado //
            ROJO = 1;   // Led rpjo apagado //
            modo = 2;
            break;
        case ESPERA_FRIO:
            if(tempe_medida == (tempe_set+2)) {
                AIRE_estado = FRIO;
            }
            if(pulsa == 4) {
                AIRE_estado  =APAGADO;
            }
            if(pulsa == 3) {
                AIRE_estado = CALOR;
            }
            AZUL = 1;   // Led azul apagado //
            ROJO = 1;   // Led rojo apagado //
            modo = 1;
            break;
    }
}


int PULS_Antirrebote(void)          // Elimina el rebote del pulsador. Devuelve "0" si ningun
{                                   // pulsador fue presionado. Si se presiona un pulsador devuelve "1",
    if (PULS_SUMA == 1) {           // "2","3" o "4" dependiendo de que pulsador fue presionado.
        pulsador = PULS_SUMA ;
    }
    if (PULS_RESTA == 1) {
        pulsador = PULS_RESTA ;
    }
    if (PULS_MODO == 1) {
        pulsador = PULS_MODO ;
    }
    if (PULS_ENCENDIDO == 1) {
        pulsador = PULS_ENCENDIDO ;
    }

    if (PULS_SUMA == 0 && PULS_RESTA == 0 && PULS_MODO == 0 && PULS_ENCENDIDO == 0) {
        pulsador = 0;
    }

    switch (PULS_estado) {
        default:
        case SUELTO:
            p = 0;
            if (pulsador == 1) {
                PULS_estado = QUIZAS_PRESIONADO;
                timeout = 30;
            }
            break;
        case QUIZAS_PRESIONADO:
            p = 0;
            if (timeout == 0 && pulsador == 1) {
                PULS_estado = PRESIONADO;
            }
            if (timeout == 0 && pulsador == 0) {
                PULS_estado = SUELTO;
            }
            break;
        case PRESIONADO:
            if (pulsador == PULS_SUMA) {
                p = 1;
            }
            if (pulsador == PULS_RESTA) {
                p = 2;
            }
            if (pulsador == PULS_MODO) {
                p = 3;
            }
            if (pulsador == PULS_ENCENDIDO) {
                p = 4;
            }
            if (pulsador == 0) {
                PULS_estado = QUIZAS_SUELTO;
                timeout = 30;
            }
            break;
        case QUIZAS_SUELTO:
            if (pulsador == PULS_SUMA) {
                p = 1;
            }
            if (pulsador == PULS_RESTA) {
                p = 2;
            }
            if (pulsador == PULS_MODO) {
                p = 3;
            }
            if (pulsador == PULS_ENCENDIDO) {
                p = 4;
            }
            
            if (timeout == 0 && pulsador == 1) {
                PULS_estado = PRESIONADO;
            }
            if (timeout == 0 && pulsador == 0) {
                PULS_estado = SUELTO;
            }
            break;
    }
    return p;
}

int DETECTOR_Flancos(int antirrebote)   // Entrega un solo "1", un solo "2", un solo "3" o un solo "4"
{                                       // cada vez que se presiona un pulsador, dependiendo de cual fue.
    switch(DETECTOR_estado) {           // Si no se presiona ningún pulsador devuelve "0".
        case NO_PRESIONADO:
            puls=0;
            if(antirrebote != 0) {
                DETECTOR_estado = APRETADO;
            }
            break;
        case APRETADO:
            if (antirrebote == 1) {
                puls = 1;
            }
            if (antirrebote == 2) {
                puls = 2;
            }
            if (antirrebote == 3) {
                puls = 3;
            }
            if (antirrebote == 4) {
                puls = 4;
            }
            DETECTOR_estado = DEJO_APRETAR;
            break;

        case DEJO_APRETAR:
            puls = 0;
            if(antirrebote == 0) {
                DETECTOR_estado = NO_PRESIONADO;
            }
            break;
    }
    return puls;
}

void Set_tempe(int m)   // Incrementa o decrementa el valor de la temperatura 
{                       // seteada de acuerdo al valor de la variable "m" 
    if(m == 1) {        // (entregada por el detector de flancos).
        tempe_set++;
    }
    if(m == 2) {
        tempe_set--;
    }
}

void timer (void)
{
    if (timeout >0)
        timeout--;
}

void Manejo_display(int pul)    // Maneja el LCD //
{
    if(pul == 4) {  // Si se toca el pulsador de encendido...//
        y++;
    }
    if (y == 2) {
        y = 0;
    }
    if (y == 1) {   // Cuando el Aire está prendido //
        lcd.TextLCD::locate(0, 0);
        lcd.printf("MODO:");
        lcd.TextLCD::locate(0, 1);
        lcd.printf("Temp medida: %d", tempe_medida);
        lcd.TextLCD::locate(0, 2);
        lcd.printf("Temp seteada: %d", tempe_set );
    }
    if(y == 0) {    // Cuando el Aire está apagado //
        lcd.cls();
    }

    if(pul == 1|| pul == 2) {           // Si se incrementa o decrementa la 
        lcd.locate(14,2);               // temperatura seteada...
        lcd.printf("%d ",tempe_set);
    }

    if(modo == 1) {                     // Si la maquina AIRE_Control está en
        lcd.TextLCD::locate(6, 0);      // estado FRIO...
        lcd.printf("FRIO ");
    }

    if(modo == 2) {
        lcd.TextLCD::locate(6, 0);      // Si la maquina AIRE_Control está en
        lcd.printf("CALOR");            // estado CALOR...
    }

    if(tempe_medida_anterior != tempe_medida) { // Si cambia la temperatura medida....
        lcd.locate(13,1);
        lcd.printf("%d ",tempe_medida);
    }

}

void Medicion_tempe(void)
{
    tempe_medida_anterior = tempe_medida;
}


