#include "mbed.h"

// PINOUT //
AnalogOut salida(PTE30);
DigitalOut IN (PTC0);
Ticker temporizador;

// ENUMS //
enum {PRE_UNO_POSITIVO, UNO_POSITIVO, PRE_UNO_NEGATIVO, UNO_NEGATIVO};

// PROTOCOLOS DE FUNCIÓN //
void AMI_Cod(int a);
void timer (void);

// VARIABLES //
int entrada[16]= {0,1,0,1,1,0,1,0,1,1,1,0,1,0,0,1};
int AMI_estado = PRE_UNO_POSITIVO;
int n=0;
int timeout = 0;

// MAIN //
int main()
{
    temporizador.attach(&timer,0.001);
    salida = 0.5;

    while(1) {
        AMI_Cod(entrada[n]);
    }
}

// FUNCIONES //
void AMI_Cod(int a)
{
    if (n == 17) {
        salida = 0.5;
        return;
    }
    if(timeout > 0) {
        return;
    }
    IN = entrada[n];

    switch(AMI_estado) {
        default:
        case PRE_UNO_POSITIVO:
            salida = 0.5;
            if(a == 1) {
                AMI_estado = UNO_POSITIVO;
            }
            break;
        case UNO_POSITIVO:
            salida = 1;
            if (a == 1) {
                AMI_estado = UNO_NEGATIVO;
            }
            if (a == 0) {
                AMI_estado = PRE_UNO_NEGATIVO;
            }
            break;
        case UNO_NEGATIVO:
            salida = 0;
            if (a == 1) {
                AMI_estado = UNO_POSITIVO;
            }
            if (a == 0) {
                AMI_estado = PRE_UNO_POSITIVO;
            }
            break;
        case PRE_UNO_NEGATIVO:
            salida = 0.5;
            if (a == 1) {
                AMI_estado = UNO_NEGATIVO;
            }
            break;
    }
    timeout = 100;
    n++;
}

void timer (void)
{
    if (timeout >0)
        timeout--;
}

