#include "mbed.h"

// ENUMS //
enum {
    ENCENDIDO,APAGADO
};
enum {
    SUELTO, QUIZAS_PRESIONADO, PRESIONADO, QUIZAS_SUELTO
};

enum {
    NO_PRESIONADO, APRETADO, DEJO_APRETAR
};


// PINOUTS //
DigitalIn PULSADOR(PTC6);
DigitalOut LED(LED_RED);
Ticker temporizador;

// VARIABLES //
int a = 0;
int b=0;
int c = 0;
int x = 0;
int timeout = 0;
int timeout2 = 0;
unsigned char LED_Estado= ENCENDIDO;
unsigned char PULS_estado = SUELTO;
unsigned char DETECTOR_estado = NO_PRESIONADO;


// PROTOCOLOS DE FUNCIO //
void LED_Titilar (void);
int PULS_Antirrebote(void);
int DETECTOR_Flancos(int antirrebote);
int Cant_toques(int detec_flan);
void timer (void);


// MAIN //
int main()
{
    temporizador.attach(&timer,0.001);

    while(1) {
        a = PULS_Antirrebote();
        b = DETECTOR_Flancos(a);
        c = Cant_toques(b);
        if(c == 1) {
            LED_Titilar (); // Led titilando 
        }
        if(c == 0) {
            LED = 1;    // Led apagado 
        }
    }
}

// FUNCIONES //

void LED_Titilar (void)     // Hace titilar al Led 
{
    if(timeout > 0)
        return;
    switch (LED_Estado) {
        default:
        case ENCENDIDO:
            LED=0;
            timeout=500;
            LED_Estado=APAGADO;
            break;
        case APAGADO:
            LED=1;
            timeout=500;
            LED_Estado=ENCENDIDO;
            break;
    }
}

int PULS_Antirrebote(void)      // Elimina el rebote del pulsador //
{
    int p;
    switch (PULS_estado) {
        default:
        case SUELTO:
            p = 0;
            if (PULSADOR == 1) {
                PULS_estado = QUIZAS_PRESIONADO;
                timeout2 = 50;
            }
            break;
        case QUIZAS_PRESIONADO:
            p = 0;
            if (timeout2 == 0 && PULSADOR == 1) {
                PULS_estado = PRESIONADO;
            }
            if (timeout2 == 0 && PULSADOR == 0) {
                PULS_estado = SUELTO;
            }
            break;
        case PRESIONADO:
            p = 1;
            if (PULSADOR == 0) {
                PULS_estado = QUIZAS_SUELTO;
                timeout2 = 50;
            }
            break;
        case QUIZAS_SUELTO:
            p = 1;
            if (timeout2 == 0 && PULSADOR == 1) {
                PULS_estado = PRESIONADO;
            }
            if (timeout2 == 0 && PULSADOR == 0) {
                PULS_estado = SUELTO;
            }
            break;
    }
    return p;
}

int DETECTOR_Flancos(int antirrebote)   // Entrega un solo "1" cada vez
{                                       // que se presiona el pulsador  
    int puls;
    switch(DETECTOR_estado) {
        case NO_PRESIONADO:
            puls=0;
            if(antirrebote == 1) {
                DETECTOR_estado = APRETADO;
            }
            break;
        case APRETADO:
            puls=1;
            DETECTOR_estado = DEJO_APRETAR;
            break;
        case DEJO_APRETAR:
            puls=0;
            if (antirrebote == 0) {
                DETECTOR_estado = NO_PRESIONADO;
            }
            break;
    }
    return puls;
}

int Cant_toques(int detect_flan)    // hace que la variable "x" cambie de "1" a "0"
{                                   // y viceversa cada vez que se toca el pulsador
    if(detect_flan == 1) {
        x++;
    }
    if(x == 2) {
        x=0;
    }
    return x;
}

void timer (void)
{
    if (timeout >0)
        timeout--;

    if (timeout2 > 0)
        timeout2--;
}