#include "SN_SnRateListener.h"
#include "SnBitUtils.h"

float SnRateListener::getRate()
{
    char results[2];
    //Pins 9 and 10 on the LPC1768 correspond to one of two i2c buses.
    I2C linkToFpga(p9,p10); //declaring this locally?
    for(uint8_t tries=0;(tries<kMaxRateReadTries)&&(getLastAck()==false);++tries)
    {
        I2C i2c(p9,p10);
        setLastAck(!i2c.read(getMMFCAddress(),results,2)); //think about sizeof(uint8_t)*2 here
    }
    setMSBs(results[0]);
    setLSBs(results[1]);
    //MSB>128
    if (((float)results[0]) > 128.0)
    {
        return 5.0625*32767.0/((float)(results[0]<<8) - 32768 + (float)(results[1]));
    }
    else
    {
     if (((float)results[0]) == 128.0)
     {
        return  (float)(32767.0/((float)results[1]))*5.0625;
     }
     else
     {
        return (((float)(results[0]<<8) + (float)(results[1]))/32767.0*5.0625);
     }
    }
    //return 0.0; //add interpretation here tomorrow, June 5th, 2019 (JCH)
}
void SnRateListener::setMSBs(uint8_t a)
{
    rateMSBs = a;
}
void SnRateListener::setLSBs(uint8_t a)
{
    rateLSBs = a;
}
uint8_t SnRateListener::getMMFCAddress()
{
    return MMFC_address;
}
void SnRateListener::setLastAck(bool a)
{
    lastAcknowledge = a;
}
bool SnRateListener::getLastAck()
{
    return lastAcknowledge;
}