#include "mbed.h"
#include "MMA8451Q.h"

#define MMA8451_I2C_ADDRESS (0x1d<<1)
#define ON  0
#define OFF !ON

//Setup the interrupts for the MMA8451Q
InterruptIn accInt1(PTA14);
InterruptIn accInt2(PTA15);//not used in this prog but this is the other int from the accelorometer

uint8_t togstat=0;//Led status
DigitalOut bled(LED_BLUE);


void tapTrue(void){
    if(togstat == 0){
        togstat = 1;
        bled=ON;
    } else {
        togstat = 0;
        bled=OFF;
    }
        
}


int main(void) {

    MMA8451Q acc(PTE25, PTE24, MMA8451_I2C_ADDRESS);//accelorometer instance
  
    acc.setDoubleTap();//Setup the MMA8451Q to look for a double Tap
    accInt1.rise(&tapTrue);//call tapTrue when an interrupt is generated on PTA14
    
    while (true) {
    //Interrupt driven so nothing in main loop
    }
}
