#ifndef MOVIE_H
#define MOVIE_H
#include "mbed.h"
#include "sbDriver.h"

/**movie class
* Used to send multiple frames of data to the Shiftbrite display.
*
* It does not inherit anything but does use a reference to a shiftBriteDisplay object.
* Example:
*   @code
*        #include "mbed.h"
*        #include "sbDriver.h"
*        #include "movie.h"
*
*        //6 leds example. Format it suitably for easy reading
*        unsigned short int aMovie[] = {
*
*        // LED1      LED2      LED3      LED4      LED5      LED6 
*        1023,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0,     //Frame 0
*            0,0,0, 1023,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0,     //Frame 1
*            0,0,0,    0,0,0,    1023,0,0, 0,0,0,    0,0,0,    0,0,0,     //Frame 2
*            0,0,0,    0,0,0,    0,0,0,    1023,0,0, 0,0,0,    0,0,0,     //Frame 3
*            0,0,0,    0,0,0,    0,0,0,    0,0,0,    1023,0,0, 0,0,0,     //Frame 4
*            0,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0,    1023,0,0,  //Frame 5
*            0,0,0,    0,0,0,    0,0,0,    0,0,0,    1023,0,0, 0,0,0,     //Frame 6
*            0,0,0,    0,0,0,    0,0,0,    1023,0,0, 0,0,0,    0,0,0,     //Frame 7
*            0,0,0,    0,0,0,    1023,0,0, 0,0,0,    0,0,0,    0,0,0,     //Frame 8
*            0,0,0, 1023,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0      //Frame 9
*        //A simple 'cylon' scanner 'movie'    
*        };
*    
*        Serial PC(PTA2, PTA1);//
*
*        //Instanced of DigitalOut for control SB signals
*        DigitalOut latch(PTC16);//010=latch
*        DigitalOut enable(PTA13);//0= enabled
*        DigitalOut reset(PTC12);
*        //Instance of the SPI contoller for SB data
*        SPI spi(PTD2,NC,PTD1);//PDT2 = MOSI=DATA. PDT1=CLK
*
*
*        int main() {
*    
*            //Instanciate a ticker object to handle framerate updates for the SB display    
*            Ticker t;
*
*            //Instanciate a string of 6 sb modules and tell the driver object where the control/data pins are
*            shiftBriteDisplay sbDisplay(&PC,latch, enable, reset, spi,6);
*
*            movie myMovie(aMovie,sbDisplay,sizeof(aMovie));
*            myMovie.setRepeat(1);
*            t.attach(&myMovie,&movie::play,0.05);//Call movie() every 0.05 seconds.Beware, if you go too fast here the FRDM will crash
*
*            while(1){
*            }
*        }
*        @endcode
*/
class movie{
    unsigned long int movieSize; //how many BYTES are in the movie array
    //NB, this is NOT the number of frames. frame Tot = ((movieSize/sizeof(unsigned short int))/frameSize)/3
    unsigned short int frameSize; //how many leds are in a display
    unsigned long int currentFrame; // which frame are we displaying now
    unsigned char f_repeat; // repeat when end is reached
    unsigned short int * movie_p;//This is where the movie data is stored
    shiftBriteDisplay r_display;//reference to the display
public:
    //movie(unsigned short int * movie_p, shiftBriteDisplay &display); // constructor - frameCount=how many frames in the movie
/**constructor.
*/
    movie(unsigned short int * movie_p, shiftBriteDisplay &display, unsigned int movieSize);
    //This must dynamically allocte 
    void play();//cycles through all known frames, one frame each time it is called
    void setRepeat(unsigned char r){f_repeat = r;};//repeat from the start or keep on showing the final frame of the movie
};
#endif