#include "mbed.h"
#include "movie.h"
#include "sbDriver.h"

movie::movie(unsigned short int * movie_p, shiftBriteDisplay &display, unsigned int movieSize):r_display(display){
    //Constructor - sets up initial condition
    //r_display = display;  //setup a reference to the actual display
    this->movie_p = movie_p; // pointer to the data. This data is simply and array of short integers but sequenced as frames
    //i.e. if the display has 2 leds and the data is {12,13,14,15,16,17,18,19,20,21,22} then the first frame is 12,13,14+15,16,17
    //corresponding to rgb_led1 and rgb_led2
    currentFrame = 0;
    frameSize = r_display.getModuleCount();
    this->movieSize = movieSize; // in BYTES. Need to (((movieSize/sizeof(unsigned short int))/frameSize)/3) to get actual frames
}

/**
* Used to play through a data 'movie' array, one frame each time this member function is called.
*/
void movie::play(){
/*Advance therough the movie one frame whenever this member method is called
    Display is referenced with r_display
*/

    unsigned int dot = 0;
    unsigned short int rTemp, gTemp, bTemp;
    
    //moduleCount is how many LEDS, assume 4, called frameSize
    //currentFrame is how many frames we've loaded
    //currentDot is which module in the frame, i.e. 0-3 in this example
    for(dot = 0; dot != frameSize; dot++){
        rTemp = *(movie_p + ((currentFrame*frameSize*3)+(dot*3)+0));
        gTemp = *(movie_p + ((currentFrame*frameSize*3)+(dot*3)+1));
        bTemp = *(movie_p + ((currentFrame*frameSize*3)+(dot*3)+2));
        r_display.setLed(dot,rTemp,gTemp,bTemp);
    }
    
    r_display.displayFrame();//update the display - MAKE IT HAPPEN
    
    currentFrame++;//Advance to the next frame
    //Check bounds
    if((currentFrame)>=((movieSize/sizeof(unsigned short int))/frameSize)/3){
        if(f_repeat == 1) currentFrame = 0;//start from first frame
        else currentFrame--; //force to repeat last frame
    }
 }