#include "mbed.h"
#include "sbDriver.h"
#include "movie.h"
# define M_PI           3.14159265358979323846
#define FACTOR 1.0
#define USI unsigned short int

// !!!!!!!!!!!!!!!!!! R E A D     T H I S     S E C T I O N    F I R S T   !!!!!!!!!!!!!
// !!!!!  INSTUCTIONS   INSTRUCTIONS   INSTRUCTIONS   INSTRUCTIONS    INSTRUCTIONS !!!!!
//A number of main loop examples follows. Select one by ...
//uncommenting ONLY ONE of the following. Then you can pick appart the relevant section.
#define BALLBOUNCE
//#define SINEWAVE
//#define VARIOUS
// !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


/** VARIOUS EXAMPLES OF HOW TO USE the shiftBriteDisplay class and the movie class follows below.
Please note, this is all 'beerware' code but I would appreciate a mention in your code headers
if you use some/all of my code/classes. My name is Johan Kritzinger and I go by 'JoKer' on MBED.
My C++ is not that hot (I'm an old PLM-51 and C programmer) but the only way to learn is to do.
Any questions, please feel free to ask.
*/


#ifdef VARIOUS
//6 leds example. Format it suitably for easy reading
unsigned short int aMovie[] = {
    /* LED1      LED2      LED3      LED4      LED5      LED6 */
    10,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0, /*Frame 0*/
       0,0,0, 100,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0, /*Frame 1*/
       0,0,0,    0,0,0,    500,0,0, 0,0,0,    0,0,0,    0,0,0, /*Frame 2*/
       0,0,0,    0,0,0,    0,0,0,    750,0,0, 0,0,0,    0,0,0, /*Frame 3*/
       0,0,0,    0,0,0,    0,0,0,    0,0,0,    900,0,0, 0,0,0, /*Frame 4*/
       0,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0,    1023,0,0, /*Frame 5*/
       0,0,0,    0,0,0,    0,0,0,    0,0,0,    900,0,0, 0,0,0, /*Frame 6*/
       0,0,0,    0,0,0,    0,0,0,    750,0,0, 0,0,0,    0,0,0, /*Frame 7*/
       0,0,0,    0,0,0,    500,0,0, 0,0,0,    0,0,0,    0,0,0, /*Frame 8*/
       0,0,0, 100,0,0,    0,0,0,    0,0,0,    0,0,0,    0,0,0  /*Frame 9*/
   /*A simple 'cylon' scanner 'movie'*/    
};
#endif

Serial PC(PTA2, PTA1);//So I can use Serial as output to terminal and input

//================== HARDWARE CONNECTIONS =========================================
//NB!!! I have only tested this on the FRDM KL25Z and h/w connection as detailed below    
//Instanced of DigitalOut for control SB signals
DigitalOut latch(PTC16);//010=latch
DigitalOut enable(PTA13);//0= enabled
DigitalOut reset(PTC12);
//Instance of the SPI contoller for SB data
SPI spi(PTD2,NC,PTD1);//PDT2 = MOSI=DATA. PDT1=CLK
//=================== END OF HARDWARE CONNECTIONS =================================

int main() {
  
    
//Instanciate a ticker object to handle framerate updates for the SB display    
Ticker t;

//Instanciate a string of 5 sb modules and tell the driver object where the control/data pins are
shiftBriteDisplay sbDisplay(latch, enable, reset, spi,6);

//=================== EXAMPLE ONE MAIN LOOP ==========================================
#ifdef VARIOUS
// MAIN PROGRAM ONE to display various features including movie class

//Example calls to method f() of shiftBriteDisplay class
//in this case, 6 of these statements wold be required to build one frame
//HOW TO BUILD A FRAME IF YOU ARE NOT USING THE MOVIE CLASS
sbDisplay.setLed(0,0XFF0000);//Red
sbDisplay.setLed(1,0X00FF00);//Green
sbDisplay.setLed(2,0X0000FF);//Blue
sbDisplay.setLed(3,0XFFFF00);//Yellow
sbDisplay.setLed(4,0X00FFFF); //Cyan?
sbDisplay.setLed(5,0XFF00FF); // Purple

//HOW TO ADJUST THE CURRENT CONTROLLERS USED FOR DOT CORRECTION
sbDisplay.setCurrentCorr(0,0,0);//suggested default value cor current control regs. Values g&b=100, r=120
sbDisplay.displayFrame();//force an update
wait(2);
sbDisplay.setCurrentCorr(127,127,127);//This should be MAX
wait(2);
//sbDisplay.setCurrentCorr(0x78,0x64,0x64);//sb suggested default
    sbDisplay.setCurrentCorr(0,0,0);//Dim

wait(2);
PC.printf("INVERTED\r\n");
sbDisplay.invert();
sbDisplay.displayFrame();
wait(2);
PC.printf("FLIP\r\n");
sbDisplay.flip();
sbDisplay.displayFrame();
wait(2);
    sbDisplay.setLed(0,0XFF0000);//Red
    sbDisplay.setLed(1,0X000500);//Green
    sbDisplay.setLed(2,0X000005);//Blue
    sbDisplay.setLed(3,0X050500);//Yellow
    sbDisplay.setLed(4,0X000505); //Cyan?
    sbDisplay.setLed(5,0X050005); // Purple
    sbDisplay.displayFrame(); //get it on the LEDS

PC.printf("RotateL");
unsigned int loop;
for (loop=0; loop != 100; loop++){
sbDisplay.rotateLeft();
sbDisplay.displayFrame();
wait(0.1);
}
PC.printf("RotateR");
//unsigned int loop;
for (loop=0; loop != 100; loop++){
sbDisplay.rotateRight();
sbDisplay.displayFrame();
wait(0.1);
}
for(loop=0; loop !=6; loop++){
    sbDisplay.shiftRight();
    sbDisplay.displayFrame();
    wait(0.2);
}
         
 
    sbDisplay.setLed(0,0X0F0000);//Red
    sbDisplay.setLed(1,0X000F00);//Green
    sbDisplay.setLed(2,0X00000F);//Blue
    sbDisplay.setLed(3,0X0F0F00);//Yellow
    sbDisplay.setLed(4,0X000F0F); //Cyan?
    sbDisplay.setLed(5,0X0F000F); // Purple
    sbDisplay.displayFrame(); //get it on the LEDS
    wait(0.5);
    sbDisplay.setCurrentCorr(0,0,0);//Dim
 
    sbDisplay.displayFrame(); //get it on the LEDS

//Alternative to calling displayFrame() yourself, setup the framerate and update the display using Ticker e.g.
//t.attach_us(&sbDisplay,&shiftBriteDisplay::displayFrame,41666);//call updateFrame 24 times per second (every 41666uS)
//or t.attach(&sbDisplay,&shiftBriteDisplay::displayFrame,0.5);// or only every 0.5s for testing
   
    
//
//EXPANDING THE FUNCTIONALITY OF shiftBriteDisplay class; USING THE MOVIE CLASS
//I know, i know, 'MOVIE' is a HUGE stretch but it sounds good right?!?!   :) 
//
//Note, it uses the previously declared sbDisplay object. It is passed as a reference.
    movie myMovie(aMovie,sbDisplay,sizeof(aMovie));
    myMovie.setRepeat(1);

    t.attach(&myMovie,&movie::play,0.05);//Beware, if you go too fast here the FRDM will crash
    while(1){;} //nothing in main loop as Ticker calls the relevan member function
#endif //VARIOUS

//=================== EXAMPLE TWO MAIN LOOP ==========================================

#ifdef SINEWAVE
//MAIN PROGRAM TWO - to show some special effects WITHOUT using the movie class
//Play around by adjusting phases, frequencies etc. Each will give different results
//Below is an example  using 3 sin waves, one for each colour, but 120 deg out of phase
//and slowly scanning frequencies from 0.5 to 5 and back again. Each freq is active for 5 seconds.

unsigned int j;
    for (j=0; j != sbDisplay.getModuleCount(); j++){
        sbDisplay.setLed(j,0,0,0);//set all led to black
    }
    sbDisplay.displayFrame();//get it on the leds
    sbDisplay.setCurrentCorr(0,0,0);//30% power
    
double tim,max_t; // 'real' time and time limit for a simulation
double w1,w2,w3; // 2*pi*f
double phase1,phase2,phase3;//Phase offset
double f1,f2,f3;//Frequencies
double factor = 250;//250 steps or values over max_t time

unsigned char f_dir = 1; //used for up and down functionality

f1 = f2 = f3 = 1.0; //frequency in herz - set all to the same
//but make a 120 degree pahse shift between the 3 waves
phase1 = 0.0;
phase2 = 120.0*(M_PI/180.0);
phase3 = 240.0*(M_PI/180.0);

max_t=5.0; //i.e. time to iterate over - i.e. 5 second
    
   while(1){ // generate special effects without using a movie and discretely calc values
        for(tim=0; tim <= max_t; tim+=max_t/factor) {
            //sbDisplay.shiftRight((unsigned short int)(5000.0*(1+sin(p+0))),(unsigned short int)(5000.0*(1+sin(p+(2.0*M_PI)/3.0))),(unsigned short int)(5000.0*(1+sin(p+2.0*((2.0*M_PI)/3.0)))));
            sbDisplay.shiftRight((USI)511.0*(1.0+sin(w1*tim+phase1)),
                                 (USI)511.0*(1.0+sin(w2*tim+phase2)),
                                 (USI)511.0*(1.0+sin(w3*tim+phase3))
            );
            sbDisplay.displayFrame();
            wait( (max_t/factor));
        }
            w1 = 2.0*M_PI*f1;
            w2 = 2.0*M_PI*f2;
            w3 = 2.0*M_PI*f3;
            if(f_dir){
                f1 = f2 = f3 = f3+0.5;
                if (f1>=5.0)f_dir = 0;
            } else {
                f1 = f2 = f3 = f3-0.5;
                if (f1<=0.5) f_dir = 1;                
            }

    } //end of while 1
#endif //SINWAVE 


//=================== EXAMPLE THREE MAIN LOOP ==========================================

#ifdef BALLBOUNCE
 //HOW ABOUT A BOUNCING BALL?
      //fisrt, clear the display
      unsigned int i;
    for(i=0 ; i != sbDisplay.getModuleCount(); i++){
        sbDisplay.setLed(i,0,0,0);
    }
    sbDisplay.displayFrame();
    
    double tim;//time
    double tf;//time it takes to fall 
    double h=0;//current height - calculated
    double h0=sbDisplay.getModuleCount();//starting height. can be anything but best to set to the number of leds in the chain
    double vi=0;//initial velocity
    double vf; //final velocity
    double g=9.81;//gravity
    double step;//size of time step in h calculation iteration    
    double cor = 0.85; //Cooeficient of restitution - a measure of how much velocity is lost when a ball bounces
    //cor is dependent on the material off the ball and the surface it bounces on.

  while(h0 >= 0.5){
    //First, find out how long before it falls h=0
    tf=sqrt((h0*2)/g);//how long to fall from h0 to 0
    step = tf/20;//dynamically calculated step size
    //---FALL ----
    for (tim = 0; tim <= tf; tim+=step) {
        h=h0-(vi*tim + 0.5*g*(tim * tim));
        //PC.printf("D%f\r\n",h);
        sbDisplay.setLed((unsigned int)h,500,0,0);//set
        sbDisplay.displayFrame();
        //wait(step);//made it too slow - enough time lost doing all the calcs
        sbDisplay.setLed((unsigned int)h,0,0,0);//clear
        sbDisplay.displayFrame();
    }
    vf=vi+g*tf;//Find final velocity (i.e., as it hits the ground
    h0=0;
    vi=vf*cor;//use vf to calc new vi using cooef of restitution
    //higest it will go
    tf=vi/g;
    step = tf/20;//alter the step size since were spending less time in this iteration
    
    //--- BOUNCE ------
    for (tim=0 ; tim <=tf; tim+=step) {
        h=(vi*tim) - 0.5*g*(tim * tim) + h0;
        //PC.printf("U%f\r\n",h);
        sbDisplay.setLed((unsigned int)h,500,0,0);//set
        sbDisplay.displayFrame();
        //wait(step);
        sbDisplay.setLed((unsigned int)h,0,0,0);//clear
        sbDisplay.displayFrame();
    }
    h0=h;
      vi=0;
   }
    while(1){}//nowhere else to go so get stuck here. User will need to reset to see another drop
#endif //BALLBOUNCE
}
 

/*TODO - 
Inheritance is one of the great features of object oriented languages like C++. The stream methods are not included in serial to allow you to use them in other classes as well. They are for example also included in the TextLCD class and in my enhanced TextLCD class. All you need to do to make use of the powerful printf features is implement a putc() method in your own new class.
from https://mbed.org/questions/1029/pcprintf-a-method/

*/
