// Programme pour  coordinateur
//Alex Veilleux veia2304
//Jean-Olivier Lessard lesj1706

#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

//Variable globale
DigitalOut led1(LED1);
DigitalOut led2(LED1);

DigitalOut reset(p8);
Serial serial_connection(p13, p14);
 
LocalFileSystem local("local"); 
int panChar;
char url;

//Permet la configuration du PAN id selon le fichier de configuration
void set_PAN(){
    int panLSB = (uint8_t)panChar;
    int panMSB = (uint8_t)(panChar >> 8);
    
    serial_connection.putc(0x7E); 
    serial_connection.putc(0x00); 
    serial_connection.putc(0x06); 
    serial_connection.putc(0x09);
    serial_connection.putc(0x01);
    serial_connection.putc(0x49);  //I
    serial_connection.putc(0x44);  //D
    //serial_connection.putc(0xAA);  // PAN ID, TODO
    //serial_connection.putc(0xBD);  // PAN ID, TODO
    serial_connection.putc(panMSB);  // PAN ID, TODO
    serial_connection.putc(panLSB);  // PAN ID, TODO
    serial_connection.putc(0x00);  // CheckSum
    
    serial_connection.putc(0x7E); 
    serial_connection.putc(0x00); 
    serial_connection.putc(0x04); 
    serial_connection.putc(0x09);
    serial_connection.putc(0x01);
    serial_connection.putc(0x57);  
    serial_connection.putc(0x52);  
    serial_connection.putc(0x4C);  
    
    serial_connection.putc(0x7E); 
    serial_connection.putc(0x00); 
    serial_connection.putc(0x04); 
    serial_connection.putc(0x09);
    serial_connection.putc(0x01);
    serial_connection.putc(0x41);  
    serial_connection.putc(0x43);  
    serial_connection.putc(0x71);  
}

//Permet la lecture du PAN et de l'Url dans un fichier local
//Entré: aucune
//Sortie: Sotcké dans variable globales
void Read_FileChar() {
      printf("Debut readfile \n\r");

    FILE *fp ;
    fp = fopen("/local/char2.txt", "r");
        
      //Si file non trouvé
    if (fp == NULL) {
        printf("Can't open input file in.list!\n\r");
        exit(1);
    }
            
        //lecture ligne par ligne
        fscanf(fp, "%X", &panChar);
        fscanf(fp, "%s", &url);

        //Fermeture fichier
    fclose (fp);     
      fp = NULL;
    printf("Fin readfile\n\r");
}

int main() {
    char message[1000];
    Read_FileChar();
    
    int cpt_frame = 0;
    int length_msb = 0;
    int length_lsb = 0;
    
    //Init reset xbee
    reset = 0; 
    led1 = 0;
    wait_ms(1);
    reset = 1;
    wait_ms(1);
    
    set_PAN();
    
     // Début programme
    printf("\r\n Websocket Example v1.0.0\r\n");
    
        //Lecture du fichier de configuration
        
    char *realurl;
    asprintf(&realurl, "%s%s%s", "ws://", &url, "/");
    printf("Real url for socket: %s\n\r", realurl);
    
    //network interface création
    EthernetInterface eth;
    eth.connect();
    printf("IP Address is %s\n\r", eth.get_ip_address());
        
    // Websocket création
      Websocket ws(realurl, &eth);
    int connect_error = ws.connect();
    
    bool trameAcce = false;
    char accData[6];
    int cptAcc;
    
    while(1) {
        if (serial_connection.readable()){
            char hex_value = serial_connection.getc();
             //printf("%X\n\r", hex_value);
            if (hex_value == 0x7E){ // Détecte une nouvelle trame
                cpt_frame = 0;
                trameAcce = false;
                cptAcc = 0;
            }
            else if(cpt_frame == 1){ // Lecture du length MSB
                length_msb = hex_value;
            }
            else if(cpt_frame == 2){ // Lecture du length LSB
                length_lsb = hex_value;
                if (length_lsb == 0x0E){
                     //Envoie au serveur par websocket pour bouton
                     int error_c = ws.send("Button pressed\r\n");
                     printf("Error code : %d \r\n", error_c);
                      if(error_c == 1)
                            printf("Error send message");
                        else{
                            printf("Message send\r\n");
                            ws.read(message);
                            printf("The message read is: %s \r\n", message);
                        }
                }
                else if(0x12){ //Longueur pour trame de l'accelerometre
                    trameAcce = true;
                }
            }
            else if (trameAcce && cpt_frame >= 0x0F && cpt_frame < (length_lsb + 0x03)){ //Permet d'aller chercher le data dynamiquement selon la longueur de la trame 
                //printf("%X\n\r", hex_value);
                accData[cptAcc] = hex_value;
                cptAcc++;
            }
            
            //Envoie au serveur par websocket pour accelerometre
            if(trameAcce && cptAcc >= 6){
                int error_c = ws.send("Button pressed\r\n");
                
                  if(error_c == 1)
                        printf("Error send message");
                    else{
                        printf("Message send\r\n");
                        ws.read(message);
                        printf("Value x: 0x%X%X    Value y: 0x%X%X   Value z: 0x%X%X \r\n", accData[0], accData[1], accData[2], accData[3], accData[4], accData[5]);
                    }
                        
                trameAcce = false;
                cptAcc = 0;
            }  
            cpt_frame++;
        }
    }
}
