/* Copyright C2014 ARM, MIT License
 *
 * Author: Doug Anson (doug.anson@arm.com)
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

// Blinky
DigitalOut led(LED1);

int main() {   

    // announce
    printf("Websocket Example v1.0.0\r\n");
    
    // Create a network interface and connect
    EthernetInterface eth;
    eth.connect();
    printf("IP Address is %s\n\r", eth.get_ip_address());

    // Create a websocket instance
    Websocket ws("ws://example.com:8080/", &eth);
    int connect_error = ws.connect();
    
    // begin main loop
    while (true) {

        // blink... 
        led = !led; 
        wait(0.5);
        
        int error_c = ws.send("Hello World\r\n");
    }
}