#include "mbed.h"
#include "ultrasonic.h"
#include "SongPlayer.h"

#define mDo 523.25
#define mDoplus 554.37
#define mRe 587.33
#define mMi 659.26
#define mFa 698.46
#define mFaplus 740
#define mSol 783.99
#define mLa 880
#define mSi 987.77
#define hDo 1046.5
#define hRe 1174.7
#define hMi 1318.5
#define hFa 1396.9
#define hSol 1568.9
#define hLa 1760.0
#define hSi 1975.5
#define half 0.24
#define full 0.48
#define threehalf 0.72
#define twofull 0.96
#define DELAY_M 4000
#define DELAY_U 5500

float note_song1[9]= {mSol,mSol,mLa,mSol,mRe,mMi,mRe,mDo,0.0};
float duration_song1[9]= {full,full,full,full,full,half,half,twofull,0.0};
float note_song2[20]= {mSol,mFaplus,mSol,hDo,mSol,mMi,mRe,mDoplus,mRe,mSol,mFa,mRe,mDo,mMi,mSol,mMi,mSol,mMi,mDo,0.0};
float duration_song2[20]= {half,half,half,half,half,half,half,half,half,half,half,half,half,half,half,half,half,half,full,0.0};

DigitalOut led(LED1);
DigitalIn  mercury1(D8);
PwmOut music(D6);

void dist(int distance)
{
    //put code here to happen when the distance is changed
    if(distance<500){
        SongPlayer mySpeaker(D6);
        mySpeaker.PlaySong(note_song2,duration_song2);
        wait_ms(DELAY_U);
    }
    else{
        wait_ms(500);
    }
    printf("Distance changed to %dmm\r\n", distance);
}

ultrasonic mu(D9, D10, .5, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
                                        //have updates every .5 seconds and a timeout after 1
                                        //second, and call dist when the distance changes
int main() {
    
    mu.startUpdates();//start mesuring the distance    
    while(1) {
        if(mercury1 == 0){
            led = 0;
            wait_ms(500);
        }
        else{
            led = 1;
            SongPlayer mySpeaker(D6);
            mySpeaker.PlaySong(note_song1,duration_song1);
            wait_ms(DELAY_M);
            }
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
                                //the class checks if dist needs to be called.
    }
}