/*  Test of custom RPC classes.   An introduction to the RPC environment.

Based heavily off of code from iva2k
http://mbed.org/users/iva2k/programs/pub_iva2k_ethrpc/gpdz3x
in turn based off of servo library
http://mbed.org/projects/cookbook/svn/Servo/trunk/Servo.h
http://mbed.org/projects/cookbook/svn/Servo/trunk/Servo.cpp

This code features heavy copy-pasting, so I take little credit for the content.  My goal was not to create original code, but to put together a basic introduction
to help myself and others understand how to implement custom classes in RPC.

This code creates a custom RPC class called LED.   The LED class contains two member functions, toggle and blink.
Normally when compiling a program the original names of the objects are lost.  In order to be able to call these functions by name after compiling, we must save the name in a string.
The name of our object and necessary arguments for the initialization function are saved using the get_rpc_class() function.    The name of each member function and their arguments must also be
registered using get_rpc_methods().




From: http://mbed.org/cookbook/Interfacing-Using-RPC

RPC Commands are in the format: "/<Object name>/<Method name> <Arguments separated by spaces>
If you send just "/" mbed will return a list of objects that can be used
If you send "/<object name>/" then mbed will return the methods which can be used on this object.

I haven't finished digging through this yet, but I think most of the documentation for the RPC functions is in the files:
http://mbed.org/projects/libraries/svn/mbed/trunk/Base.h
http://mbed.org/projects/libraries/svn/mbed/trunk/rpc.h


*/
/** Includes

*
*/
#include "mbed.h"
#include "rpc.h"


/**Class: LED
*
*attached to an LED pin, contains simple blink functionality over serial
*/
class LED :public Base { //make sure to define the class with inheritance from the Base RPC class.
public:
    /**
    *Constructor
    */
    LED(PinName mypin, const char *name=NULL);
    /**Blink LED*/
    void blink(int n);
    /** switch state of LED*/
    int toggle();
    /** pin LED is attached to*/
    DigitalOut LEDpin;
    /**state of LED
    */
    int state;

#ifdef MBED_RPC  //this code will not compile unless we have included the rpc.h file.    So this class can also be used without RPC.
    /**Defines the methods available over RPC*/
    virtual const struct rpc_method *get_rpc_methods();
    /**Defines the RPC class*/
    static struct rpc_class *get_rpc_class();
#endif    // MBED_RPC  
};