#include LED.h


/**Initialization Function**/
LED::LED(PinName mypin, const char *name) : Base(name), LEDpin(mypin) { //initialize pin    
    LEDpin.write(0);
    state=false;  //set LED to off
}
/**switch the state of the LED**/
int LED::toggle() {    
    if (state==0) {
        state=1;
    } else {
        state=0;
    }
    LEDpin=state;
    return state; //print the current state of the LED
}

/**blink the LED n times**/
void LED::blink(int n=1) {   
    do { //blink at least once
        toggle(); //toggle LED state
        wait(.2);
        toggle(); //return LED to original state
        wait(.2);
        n--;
    } while (n>=1);
}


#ifdef MBED_RPC 
/**Create a list of the available methods which can be called for this class**/
const rpc_method *LED::get_rpc_methods() {    
    static const rpc_method rpc_methods[] = {
        { "toggle", rpc_method_caller<int, LED, &LED::toggle> },  //first specify the name string.   The arguments to rpc_method_caller appear to be <outputs, RPC class, inputs, reference to function>.
        //In this case, we have one output and no inputs so they are skipped.   We must only specify the class of the object the method belongs to and the address of the method.

        { "blink", rpc_method_caller<LED, int, &LED::blink> },  //this method has no outputs so they are skipped, but we must specify the input to be of type int.
        RPC_METHOD_SUPER(Base), 
    };
    return rpc_methods;
}
/**Register the class itself as an RPC-callable class**/
rpc_class *LED::get_rpc_class() {    
    static const rpc_function funcs[] = {
        { "new", rpc_function_caller<const char*, PinName, const char*, &Base::construct<LED,PinName,const char*> > },  //still don't fully understand the arguments in this line. I suppose the first argument may just be an output echo of the name.
        RPC_METHOD_END
    };
    static rpc_class c = { "LED", funcs, NULL };
    return &c;
}
#endif    // MBED_RPC


/* end LED class definition */





Serial pc(USBTX, USBRX); //set up serial communication
/**Wait for RPC commands and then call the interpreter**/
int main() {   
    // specify which classes we would like to be able to call over LED
    Base::add_rpc_class<Timer>();  //a class included in the core mbed RPC library
    Base::add_rpc_class<LED>();    //my own custom LED class

    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while (1) {
        pc.gets(buf, 256); //grab serial commands
        rpc(buf, outbuf);  //interpret the RPC commands
        //this function only requires an input string and output string, so we can obtain RPC commands via a different interface than serial if desired.
        pc.printf("%s\n", outbuf); //print back over serial
    }
}



