#include "MCP4922.h"

MCP4922::MCP4922(int SPIchannelNum, PinName _CS, PinName _LDAC) : DAC_SPI(SPIchannelNum, _CS, _LDAC){    
    messageBits(16);  //messages use a 16 bit word
    frequency(20000000);  //set default frequency to 20MHz    
    autoUpdate=1;
    VrefA=5000; //assume a 5V reference voltage for use with write_mv().  This value can be configured;
    VrefB=5000;
    gain =1; //set gain to x1 to match Vref.
    buffered =0; //leave output buffer off
}

void MCP4922::select(char DACnum){
    DACselect=DACnum & 0x01; //choose between DAC A and DAC B
}

void MCP4922::write_mV(int mV){
    int Vref;
    if (DACselect==1){
        Vref=VrefB;
    }
    else{
        Vref=VrefA;
    }
    int DACvalue= mV* 4096/Vref *(gain+1); //scale voltage to a DAC value.
    write(DACvalue);
}

void MCP4922::write(int value){
    //valid input values are 0 - 4095.   4096 should scale to Vref.   
    //All serial commands are 16 bit words.   The highest 4 bits are control bits, while the last 12 are the data bits for the 12-bit DAC MCP4822.
    //bit 15: select which DAC to use.
    //bit 14: 0=unbuffered , 1= buffered
    //bit 13: 0= gain x2, 1= gain x1
    //bit 12: 0= DAC active, 1= shut down DAC
    //bit 11-0: Data bits for the DAC.
    
    if (value > 0xFFF){
        value = 0xFFF;  //any out of range values will be truncated to our max value
    }    
    value=value & 0xFFF; //limit our value to 12 bits.
    
    //SCK=0;  //set the clock low.   Data is read on the rising edge of the clock.  
    LDAC=1;
    CS=0; //enable the chip to recieve data
    //bit 13: 0= gain x2, 1= gain x1
    char controlbits=(DACselect<<3) + (buffered<<2) + (gain<<1) +1;
    
    int message= (controlbits<<12)+value;
    (*DACspi).write(message);
    CS=1;  //signal end of message.   The data will be loaded into the internal registers.
    if(autoUpdate){ LDAC=0;} //trigger the update of the output voltage.
      
}
void MCP4922::update(){
    //triggers the DAC to update output on command.   Useful if we wish to synchronize the DAC output value with another event.
    LDAC=0;
}

//Set the multiplying factor for the output.  Valid inputs are gains of 1 and 2.*/
void MCP4922::setGain(int gain_value){
    if (gain_value>1){ 
        gain =1; //Set gain to x2
    }
    else{
        gain=0; //Set gain to x1.   Limits range to 2.098mV
    }
}