#include "MCP4822.h"

//initialization function
MCP4822::MCP4822(int SPIchannelNum, PinName _CS, PinName _LDAC) : DAC_SPI(SPIchannelNum, _CS, _LDAC){    
    messageBits(16);
    frequency(20000000);    
    autoUpdate=1;
    gain =0; //set gain to x2 to get full range
}

void MCP4822::select(char DACnum){
    DACselect=DACnum & 0x01; //choose between DAC A and DAC B
}

void MCP4822::write_mv(int mVolts){  //since out reference diode is at 4.096V, we can directly map our voltage values to DAC values when gain is set to x2.
    if (gain==0){ //gain is x2
        write(mVolts);
    }
    else{ //gain is x1
        write(mVolts*2);
    }
}

void MCP4822::write(int value){
    //valid voltage values are up to 4096mV.  We directly map our value to mV.  
    //All serial commands are 16 bit words.   The highest 4 bits are control bits, while the last 12 are the data bits for the 12-bit DAC MCP4822.
    //bit 15: select which DAC to use.
    //bit 14: unused
    //bit 13: 0= gain x2, 1= gain x1
    //bit 12: 0= DAC active, 1= shut down DAC
    //bit 11-0: Data bits for the DAC.
    if (value > 0xFFF){
        value = 0xFFF;  //any out of range values will be truncated to our max value
    }      
    
    value=value & 0xFFF; //limit our value to 12 bits.
    //SCK=0;  //set the clock low.   Data is read on the rising edge of the clock.
    LDAC=1;
    CS=0; //enable the chip to recieve data
    char controlbits=(DACselect<<3)+(gain<<1) +1;
    
    int message= (controlbits<<12)+value;
    (*DACspi).write(message);
    CS=1;  //signal end of message.   The data will be loaded into the internal registers.
    if(autoUpdate){ LDAC=0;} //trigger the update of the output voltage.
      
}
void MCP4822::update(){
    //triggers the DAC to update output on command.   Useful if we wish to synchronize the DAC output value with another event.
    LDAC=0;
}

//Set the multiplying factor for the output.  Valid inputs are gains of 1 and 2.*/
void MCP4822::setGain(int gain_value){
    if (gain_value>1){ 
        gain =1; //Set gain to x2
    }
    else{
        gain=0; //Set gain to x1.   Limits range to 2.098mV
    }
}