#include "MAX500.h"

MAX500::MAX500(int SPIchannelNum, PinName _LOAD, PinName _LDAC) : DAC_SPI(SPIchannelNum, _LOAD, _LDAC){   //We use the 3 wire serial interface, since the timing is more standardized. 
    (*DACspi).format(10,2);  //messages use a 10 bit word, and read data on the falling edge with the clock defaulting to HIGH.
    frequency(5000000);  //set default frequency to 5MHz since unstated   
    autoUpdate=1;
    VrefAB=5000; //assume a 5V reference voltage for use with write_mv().  This value can be configured;
    VrefC=5000; //assume a 5V reference voltage for use with write_mv().  This value can be configured;
    VrefD=5000; //assume a 5V reference voltage for use with write_mv().  This value can be configured;
    CS=1; //CS is our LOAD pin
}

void MAX500::select(char DACnum){
    DACselect=DACnum & 0x03; //choose between DAC A , B, C or D
}

void MAX500::write_mV(int mV){
    int Vref;
    if (DACselect==0 || DACselect ==1){
        Vref=VrefAB;
    }
    else if (DACselect ==2) {
        Vref=VrefC;
    }
    else{
        Vref=VrefD;
    }
    int DACvalue= mV* 255/Vref ; //scale voltage to a DAC value.
    write(DACvalue);
}

void MAX500::write(int value){
    //valid input values are 0 - 255.   255 should scale to Vref.   
    //All serial commands are 10 bit words.   The highest 2 bits are control bits, while the last 8 are the data bits for the 8-bit DAC MAX500.

    //bit 9-8: Selection bits for DAC
    //bit 7-0: Data bits for the DAC.
    
    if (value > 0x0FF){
        value = 0x0FF;  //any out of range values will be truncated to our max value
    }    
    value=value & 0x0FF; //limit our value to 8 bits.
    
    //SCK=0;  //set the clock low.    
    LDAC=1;
    CS=1; //enable the chip to recieve data    
    
    int message= (DACselect<<8)+value;
    (*DACspi).write(message);
    //wait_us(5);
    CS=0;  //signal end of message.   The data will be loaded into the internal registers.
    //wait_us(5);
    CS=1;
    if(autoUpdate){ LDAC=0;} //trigger the update of the output voltage.
      
}
void MAX500::update(){
    //triggers the DAC to update output on command.   Useful if we wish to synchronize the DAC output value with another event.
    LDAC=0;
}

