#ifndef DAC_SPI_H
#define DAC_SPI_H
#include "mbed.h"

/* a basic parent library for use with DACs controlled via SPI.  Individual hardware implementations will need their own libraries.
This provides basic initialization of common pins and provides a serial channel.   Doesn't provide a lot of added functionality, but serves as an interface for the SPI library.
*/
class DAC_SPI
{
    public:
    DAC_SPI(int SPIchannelNum, PinName CS,  PinName LDAC);
    virtual void select(char DACvalue); //choose the active DAC
    virtual void write(int DACvalue) =0; //write a value to the Digital Analog Converter    
    virtual void write_mV(int millivolts) =0; //write a value to the Digital Analog Converter specified in mV (may require appropriate scaling factor)
    
    /** Manually change the SPI frequency 
    * @param freq Desired frequency in hertz: must be a value supported by both the mbed and DAC.  The MCP4922 supports frequencies to 20MHz.
    */
    void frequency(int freq);
    //set the number of bits for DAC
    void messageBits(int bits);
    //DigitalOut SCK;
    /** The currently selected DAC channel.  0 for DAC A, 1 for DAC B, etc*/
    char DACselect;
    DigitalOut CS;  //serial chip select pin
    DigitalOut LDAC; //synchronize pin to update both DACs together    
    SPI * DACspi;  //SPI channel.  0 for p5-p7, 1 for p11-p13
};

extern SPI SPI_A;  //channel A SPI (pins 5,7)
extern SPI SPI_B;  //channel B SPI (pins 11,13)

#endif //DAC_H