#ifndef DAC_SPI_CPP
#define DAC_SPI_CPP

#include "DAC_SPI.h"
/*SPI Channels */
                          //since we only have two SPI channels, which must be shared, define them here.  
SPI SPI_A(p5, NC, p7);    //If using with other serial devices, can pass a pointer to the serial channel.
SPI SPI_B(p11, NC, p13);

/*Initialize DAC */
DAC_SPI::DAC_SPI(int SPIchannelNum, PinName _CS, PinName _LDAC) : CS(_CS), LDAC(_LDAC){  
    if (SPIchannelNum ==1){
        DACspi = &SPI_B;
    }  
    else{
        DACspi = &SPI_A;
    }
    messageBits(16);
}

/** Manually change the SPI frequency 
* Must be a value supported by the mbed and DAC
*/
void DAC_SPI::frequency(int freq){
    (*DACspi).frequency(freq);    
}


//specify the number of bits used in message packets to the DAC.
void DAC_SPI::messageBits(int bits){
    (*DACspi).format(bits,0);
}

//select a DACnum for use with chips with multiple onboard DACs.
void DAC_SPI::select(char DACnum){
    DACselect=DACnum;
}

#endif //DAC_SPI_CPP