#ifndef CHEMIN_H
#define CHEMIN_H
// C code to implement Priority Queue 
// using Linked List 
// https://www.geeksforgeeks.org/priority-queue-using-linked-list/

// C code for path fining 
// https://github.com/AtsushiSakai/PythonRobotics

//Exemple: 
/*
int vitesse_deplacement = 200;

calc_distances(20,180,270,180);   //x_départ , y_arrivée , x_arrivée, y_arrivée
Node* commandes = (Node*)malloc(sizeof(Node));
commandes = traduction_points_commandes(trouver_chemin(20,180,270,180)); 
while(!isEmpty(&commandes)){ 
    int angle,distance_avancement_cm,_ = 0;
    peek(&commandes,&angle,&distance_avancement_cm,&_);     //on recupere les infos du point
    pop(&commandes);
    printf("rotation %d, avancement de %d\n",angle,distance_avancement_cm);
    if(distance_avancement_cm != 0 && angle != 0) {
        test_ligne_droite(10*distance_avancement_cm, vitesse_deplacement); 
        test_rotation_rel(angle,vitesse_deplacement);
    }
}
*/


#include <stdio.h>
#include <stdlib.h> 
#include <time.h>



  
// Node 
typedef struct node { 
    int x;
    int y;
    int distance; 
  
    // Lower values indicate higher priority 
    int priority; 
  
    struct node* next; 
  
} Node; 
  
// Function to Create A New Node 
Node* newNode(int x , int y, int distance, int p);
  
// Return the value at head 
void peek(Node** head, int*x, int*y, int*distance);
  
// Removes the element with the 
// highest priority form the list 
void pop(Node** head);

// Function to push according to priority 
void push(Node** head, int x, int y, int distance, int p);

// Function to check is list is empty 
int isEmpty(Node** head);


void calc_distances(int ox, int oy, int gx , int gy); //ogigine, goal

Node* trouver_chemin(int ox, int oy, int gx , int gy); //retourne une suite de points ,  du point de départ au point d'arrivé en évitant les obstacles

Node* traduction_points_commandes(Node* pq);

void afficher_terrain();
void afficher_terrain(Node* commandes);

int conversion_codage_angles(int o);


void aller_a_point(int ox , int oy, int gx , int gy , int vitesse_deplacement = 100);

#endif


