#ifndef STRATEGIE_H
#define STRATEGIE_H
/**
 ****************************************************************************
 * @file    Strategie.h
 * @author  Jimmy MAINGAM
 * @version V0.0.1
 * @date    04/05/2019
 * @brief   Implementation file to communicate with the screen 
 ****************************************************************************
 *This software has been developed to be used in AREM's robot for the cdfr 2019
 **/
 
 /* Includes ------------------------------------------------------------------*/
 
#include "mbed.h"
#include "hardware.h"
#include "odometrie.h"
#include "reglages.h"
#include "deplacement.h"
#include "demarreur.h"
#include "Ecran.h"
#include "AnalyseDistance.h"
#include "pinMap.hpp"
#include "consigne.h"

/* Constants -------------------------------------------------------------------*/

#define TEMPSMATCH 99 
#define ARRET 0
#define ARC 2
#define RECTANGLE 1
/* Global Variables ---------------------------------------------------------*/   



/* Public Functions ------------------------------------------------------------------*/

void strategieHomologationViolet(deplacement robot, Demarreur demarreur);
void strategieHomologationJaune(deplacement robot, Demarreur demarreur);

void strategieClassiqueViolet(deplacement robot, Demarreur demarreur);
void strategieClassiqueJaune(deplacement robot, Demarreur demarreur);

void strategieRCVAViolet(deplacement robot, Demarreur demarreur);
void strategieRCVAJaune(deplacement robot, Demarreur demarreur);

void strategieHumiliationViolet(deplacement robot, Demarreur demarreur);
void strategieHumiliationJaune(deplacement robot, Demarreur demarreur);

void updateAndWriteScore(char n1, char n2, char n3);

void arretSystem(deplacement robot);

void LectureI2CCarteCapteur(deplacement robot); // a remplacer par un include de la lib I2C d'Antoine

#endif

