#include "Strategie.h"

char bufferScore[3]= {'0','0','0'};

bool typeMovement = DEPLACEMENT_AVANT;
int typeEvitement = ARRET;

extern bool finActions;
extern int distanceUltrasonGauche;
extern int distanceUltrasonDroit;
extern int distanceUltrasonArriere;

extern int distanceTOF1;
extern int distanceTOF2;
extern int distanceTOF3;
extern int distanceTOF4;
extern int distanceTOF5;


extern bool stopCapteurs;

extern Serial pc;


Timeout tempsArretMvt;
bool actionLancer = false;


void updateAndWriteScore(char n1, char n2, char n3)
{
    bufferScore[0] = n1;
    bufferScore[1] = n2;
    bufferScore[2] = n3;
    write(bufferScore);
}


void LectureI2CCarteCapteur(deplacement robot)
{
    pc.printf("Avant le traitement\n\r");
    traitementBufferCapteurs();
    pc.printf("Apres le traitement\n\r");
    if(AnalyseDistance(distanceUltrasonGauche, distanceUltrasonDroit, distanceUltrasonArriere, typeMovement) == ROBOT) {
        if( ((distanceUltrasonGauche <= 300)  || (distanceUltrasonDroit <= 300)) || (distanceUltrasonArriere <= 300) && (typeMovement == DEPLACEMENT_AVANT) ) {
            stopCapteurs = true;
        } else {
            stopCapteurs = false;
        }
    } else {
         stopCapteurs = false;
     }
}

void arretSystem()
{

    deplacement robot;

    robot.initialisation();
    set_PWM_moteur_D(0);
    set_PWM_moteur_G(0);
    motors_stop();
    stopPompe();
    while(1);
    //robot.arreterRobot();
}

/*---------Debut Strategie homologation violet ------------------------------------------------------*/


void strategieHomologationViolet(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    while(demarreur.getState() == false) {
        //on attend
        pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    initViolet();
    //robot.initialisation();
    lancerTimerEcran();
    tempsMatch.start();
    typeEvitement = ARRET;
    while(tempsMatch  <= TEMPSMATCH) {
        /*if(finActions == true)
         {
             etapeMatch++;
             finActions = false;
        }*/
        switch (etapeMatch) {

            case 0 : { /* On tourne pour aller vers le terrain adverse et on avance jusqu'au milieu du terrain */

                wait(1);
                prendre4Palets();
                wait(3);
                stopPompe();
                wait(5);
                robot.ligne_droite_basique(120000);
                robot.marche_arriere(-120000);
                robot.rotation_rel(-90);
                robot.ligne_droite_basique(60000);
                robot.rotation_rel(90);
                robot.ligne_droite_basique(80000);
                etapeMatch++;

                break;

                default: {
                    robot.vitesse_nulle_D(0);
                    robot.vitesse_nulle_G(0);
                    motors_stop();
                }
            }
        }

        //Arrêter les moteurs
        robot.vitesse_nulle_D(0);
        robot.vitesse_nulle_G(0);
        motors_stop();
        while(1);
    }
}
/*-------Fin Stratégie homologation violet------------------------------------------------------------*/


/*-------Debut Strategie homologation jaune-----------------------------------------------------------*/


void strategieHomologationJaune(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    while(demarreur.getState() == false) {
        //on attend
        //pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    //initJaune();
    //robot.initialisation();
    lancerTimerEcran();
    tempsMatch.start();
    typeEvitement = ARRET;
    while(tempsMatch  <= TEMPSMATCH) {
        switch (etapeMatch) {

            case 0 : { /* On tourne pour aller vers le terrain adverse et on avance jusqu'au milieu du terrain */

                typeMovement = DEPLACEMENT_AVANT;
                setEmplacementTest();
                init_odometrie();
                robot.va_au_point(80000,30000,-90);
                robot.va_au_point(80000,80000,-90);
                robot.va_au_point(30000,80000,-90);
                robot.va_au_point(30000,30000,-90);
                //robot.ligne_droite_basique(127500);
                etapeMatch++;

                break;
            }
            default: {
                robot.vitesse_nulle_D(0);
                robot.vitesse_nulle_G(0);
                motors_stop();
                stopPompe();
            }
        }
    }

    //Arrêter les moteurs
    robot.vitesse_nulle_D(0);
    robot.vitesse_nulle_G(0);
    motors_stop();
    stopPompe();
    while(1);
}

/*Fin Strategie homologation jaune -------------------------------------------------------------------*/


/*Debut Strategie classique violet -------------------------------------------------------------------*/


void strategieClassiqueViolet(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    initViolet();
    while(demarreur.getState() == false) {
        //on attend
        pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    //robot.initialisation();//check si modif
    lancerTimerEcran();
    tempsMatch.start();
    //typeEvitement = ARRET;

    while(tempsMatch  <= TEMPSMATCH) {
        switch (etapeMatch) {

            case 0 : { /* on prend les 3 palets du petit distributeur */
                typeMovement = DEPLACEMENT_AVANT;
                typeEvitement = ARRET;
                robot.va_au_point(27500,178000,90);
                etapeMatch++;
                break;
            }
            case 1: {
                if(actionLancer != true) {
                    prendre3Palets();
                    actionLancer = true;
                }

                if(finActions == true) {
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 2 : { /* On se place entre la case rouge et verte pour poser le palet rouge */
                robot.poussette(2000); 
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-50000);
                robot.rotation_abs(-90);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(22500,60000,-90);
                etapeMatch++;
                break;
            }
            case 3 : { 
                if(actionLancer != true) {
                    lacherVentouse3();
                    actionLancer = true;
                }
                if(finActions == true) {
                    updateAndWriteScore('0', '0', '6');
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 4 : { /* On se place entre la case verte et bleue pour poser le palet vert */
                typeMovement = DEPLACEMENT_ARRIERE;
                wait(2);
                robot.marche_arriere(-30000);
                etapeMatch++;
                break;
            }
            case 5 : {
                if(actionLancer != true) {
                    lacherVentouse2();
                    actionLancer = true;
                }
                if(finActions == true) {
                    updateAndWriteScore('0', '1', '2');
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 6 : { /* On se place en bordure de la case bleue pour poser le palet bleu */
            wait(2);
                robot.marche_arriere(-30000);
                
                etapeMatch++;
                break;
            }
            case 7 : {
                if(actionLancer != true) {
                    lacherVentouse1();
                    stopPompe();
                    actionLancer = true;
                }
                if(finActions == true) {
                    updateAndWriteScore('0', '1', '8');
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 8 : {
                wait(2);
                robot.marche_arriere(-50000);
                etapeMatch = 30;;
                break;
            }
            case 9 : { /* on est placé devant le grand distributeur pour prendre les 4 premiers palets */
                typeMovement = DEPLACEMENT_AVANT;
                //robot.va_au_point(70000,130000,90);
                robot.va_au_point(65000,130000,90);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
                break;
            }
            case 10 : {
                if(actionLancer != true) {
                    prendre4Palets();
                    actionLancer = true;
                }
                if(finActions == true) {
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 11 : {
                robot.poussette(2000);
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                etapeMatch++;
                break;
            }
            case 12 :    /* On se place devant la case bleu, on pousse le palet qui y est devant puis on lache le bleu */
            {
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(70000,105000,180);
                robot.ligne_droite_basique(10000);
                etapeMatch++;
                break;
            }
            case 13 : 
            {
                if(actionLancer == false)
                {
                    lacherVentouse4();
                    updateAndWriteScore('0', '2', '4');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 14 : /* On se place devant la case verte et on lache le vert*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(58000,83000,180);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 15 : 
            {
                if(actionLancer == false)
                {
                    lacherVentouse2();
                    updateAndWriteScore('0', '3', '0');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 16 : /* On se place devant la case rouge et on lache le rouge*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(58000,45000,180);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 17 : 
            {
                if(actionLancer == false)
                {
                    //lacherVentouse1();
                    //lacherVentouse3();
                    stopPompe();
                    updateAndWriteScore('0', '4', '2');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 18 : 
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                etapeMatch++;
            break;
            }
            case 19 : /* On depose prend les 2 derniers palets du grand distributeur */
            {
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(85000,130000,90);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 20 : 
            {
                if(actionLancer != true) {
                    prendre2Palets();
                    actionLancer = true;
                }
                if(finActions == true) {
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 21 : 
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                etapeMatch++;
            break;
            }
            case 22 : /* On se place devant la case verte et on lache le vert*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(58000,83000,180);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 23 : 
            {
                if(actionLancer == false)
                {
                    lacherVentouse4();
                    updateAndWriteScore('0', '4', '8');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 24 : /* On se place devant la case rouge et on lache le rouge*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(58000,45000,180);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 25 : 
            {
                if(actionLancer == false)
                {
                    //lacherVentouse3();
                    stopPompe();
                    updateAndWriteScore('0', '5', '4');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
/*            case 26 : 
            {
                if(actionLancer == false)
                {
                    stopPompe();
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }*/
            case 26 : /* On laisse la place au robot2 */
            {
                
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(65000,130000,90);
                etapeMatch++;
            break;
            }
            default: {
                robot.vitesse_nulle_D(0);
                robot.vitesse_nulle_G(0);
                motors_stop();
                stopPompe();
                stopPompe();
                stopPompe();
            }
        }
    }

    //Arrêter les moteurs
    robot.vitesse_nulle_D(0);
    robot.vitesse_nulle_G(0);
    motors_stop();
    stopPompe();
    while(1);
}

/*-------- Fin Strategie classique violet -----------------------------------------------*/


/*------- Debut Strategie classique Jaune -----------------------------------------------*/


void strategieClassiqueJaune(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    initJaune();
    while(demarreur.getState() == false) {
        //on attend
        //pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    //robot.initialisation();//check si modif
    lancerTimerEcran();
    tempsMatch.start();
    //typeEvitement = ARRET;

    while(tempsMatch  <= TEMPSMATCH) {
        switch (etapeMatch) {

            case 0 : { /* on prend les 3 palets du petit distributeur */
                typeMovement = DEPLACEMENT_AVANT;
                typeEvitement = ARRET;
                //robot.va_au_point(271800,178000,90);
                robot.ligne_droite_basique(77000);
                robot.poussette(2000); 
                robot.marche_arriere(-3000);
                etapeMatch++;
                break;
            }
            case 1: {
                if(actionLancer != true) {
                    prendre3Palets();
                    actionLancer = true;
                }
                if(finActions == true) {
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 2 : { /* On se place entre la case rouge et verte pour poser le palet rouge */
                robot.poussette(2000); 
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-50000);
                robot.rotation_abs(-90);
                typeMovement = DEPLACEMENT_AVANT;
                //robot.va_au_point(277500,60000,-90);
                robot.ligne_droite_basique(95000);
                etapeMatch++;
                break;
            }
            case 3 : { 
                if(actionLancer != true) {
                    lacherVentouse2();
                    actionLancer = true;
                }
                if(finActions == true) {
                    updateAndWriteScore('0', '0', '6');
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 4 : { /* On se place entre la case verte et bleue pour poser le palet vert */
                typeMovement = DEPLACEMENT_ARRIERE;
                wait(1);
                robot.marche_arriere(-30000);
                etapeMatch++;
                break;
            }
            case 5 : {
                if(actionLancer != true) {
                    lacherVentouse3();
                    actionLancer = true;
                }
                if(finActions == true) {
                    updateAndWriteScore('0', '1', '2');
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 6 : { /* On se place en bordure de la case bleue pour poser le palet bleu */
                wait(1);
                robot.marche_arriere(-30000);
                etapeMatch++;
                break;
            }
            case 7 : {
                if(actionLancer != true) {
                    lacherVentouse4();
                    actionLancer = true;
                }
                if(finActions == true) {
                    updateAndWriteScore('0', '1', '8');
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 8 : {
                wait(1);
                robot.marche_arriere(-15000);
                robot.rotation_abs(180);
                robot.ligne_droite_basique(40000);
                robot.rotation_abs(90);
                robot.ligne_droite_basique(5000);
                robot.poussette(2000);
                robot.marche_arriere(-3000);
                etapeMatch++; //a modifier après le match 
                break;
            }
            case 9 : { /* on est placé devant le grand distributeur pour prendre les 4 premiers palets */
                if(actionLancer != true) {
                    prendre4Palets();
                    actionLancer = true;
                }
                if(finActions == true) {
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 10 : {
                robot.poussette(3000);
                robot.marche_arriere(-10000);
                etapeMatch++;
                break;
            }
            case 11 : {
                //prise des 4 
                while(1);
                robot.poussette(2000);
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                etapeMatch++;
                break;
            }
            case 12 :    /* On se place devant la case bleu, on pousse le palet qui y est devant puis on lache le bleu */
            {
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(230000,105000,0);
                robot.ligne_droite_basique(10000);
                etapeMatch++;
            }
            case 13 : 
            {
                if(actionLancer == false)
                {
                    lacherVentouse1();
                    updateAndWriteScore('0', '2', '4');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 14 : /* On se place devant la case verte et on lache le vert*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(242000,83000,0);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 15 : 
            {
                if(actionLancer == false)
                {
                    lacherVentouse3();
                    updateAndWriteScore('0', '3', '0');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 16 : /* On se place devant la case rouge et on lache le rouge*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(242000,45000,0);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 17 : 
            {
                if(actionLancer == false)
                {
                    //lacherVentouse2();
                    //lacherVentouse4();
                    stopPompe();
                    updateAndWriteScore('0', '4', '2');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 18 : 
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                etapeMatch++;
            break;
            }
            case 19 : /* On depose prend les 2 derniers palets du grand distributeur */
            {
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(215000,130000,90);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 20 : 
            {
                if(actionLancer != true) {
                    prendre2Palets();
                    actionLancer = true;
                }
                if(finActions == true) {
                    finActions = false;
                    actionLancer = false;
                    etapeMatch++;
                }
                break;
            }
            case 21 : 
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                etapeMatch++;
            break;
            }
            case 22 : /* On se place devant la case verte et on lache le vert*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(242000,83000,0);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 23 : 
            {
                if(actionLancer == false)
                {
                    lacherVentouse1();
                    updateAndWriteScore('0', '4', '8');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 24 : /* On se place devant la case rouge et on lache le rouge*/
            {
                typeMovement = DEPLACEMENT_ARRIERE;
                robot.marche_arriere(-5000);
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(242000,45000,00);
                robot.ligne_droite_basique(5000);
                etapeMatch++;
            break;
            }
            case 25 : 
            {
                if(actionLancer == false)
                {
                    //lacherVentouse2();
                    stopPompe();
                    updateAndWriteScore('0', '5', '4');
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 26 : 
            {
                if(actionLancer == false)
                {
                    stopPompe();
                    actionLancer = true;
                }
                if(finActions)
                {
                    actionLancer = false;
                    finActions = false;
                    etapeMatch++;
                }
            break;
            }
            case 27 : /* On laisse la place au robot2 */
            {
                
                typeMovement = DEPLACEMENT_AVANT;
                robot.va_au_point(235000,130000,90);
                etapeMatch++;
            break;
            }
            default: {
                robot.vitesse_nulle_D(0);
                robot.vitesse_nulle_G(0);
                motors_stop();
                stopPompe();
                stopPompe();
                stopPompe();
            }
        }
    }

    //Arrêter les moteurs
    robot.vitesse_nulle_D(0);
    robot.vitesse_nulle_G(0);
    motors_stop();
    stopPompe();
    while(1);
}
/*--------- Fin Strategie classique jaune --------------------------------------------*/


/*--------- Debut Strategie RCVA violet ----------------------------------------------*/


void strategieRCVAViolet(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    while(demarreur.getState() == false) {
        //on attend
        //pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    initViolet();
    robot.initialisation();
    lancerTimerEcran();
    tempsMatch.start();
    typeEvitement = ARRET;
}


/*-------- Fin Strategie  RCVA violet -----------------------------------------------*/


/*-------- Debut Strategie RCVA jaune -----------------------------------------------*/

void strategieRCVAJaune(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    while(demarreur.getState() == false) {
        //on attend
        //pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    initJaune();
    robot.initialisation();
    lancerTimerEcran();
    tempsMatch.start();
    typeEvitement = ARRET;
}


/*-------- Fin Strategie RCVA jaune --------------------------------------------------*/

/*-------- Debut Strategie humiliation  violet ---------------------------------------*/

void strategieHumiliationViolet(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    while(demarreur.getState() == false) {
        //on attend
        //pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    initViolet();
    robot.initialisation();
    lancerTimerEcran();
    tempsMatch.start();
    typeEvitement = ARRET;
}


/*--------- Fin Strategie humiliation violet ----------------------------------------*/


/*-------- Debut Strategie humiliation jaune ----------------------------------------*/

void strategieHumiliationJaune(deplacement robot, Demarreur demarreur)
{
    write(bufferScore);
    Timer tempsMatch; // timer en seconde
    int etapeMatch = 0;
    while(demarreur.getState() == false) {
        //on attend
        //pc.printf("On attend le depart du Robot Thanos\n\r");
    }
    tempsArretMvt.attach(&arretSystem, TEMPSMATCH);
    initJaune();
    robot.initialisation();
    lancerTimerEcran();
    tempsMatch.start();
    typeEvitement = ARRET;
}


/*--------- Fin Strategie humiliation jaune -----------------------------------------*/




