/**************************************************************************
*                                                                         *
*   This example builds on Segments_01_Simple by introducing an example   *
*   of how brightness might be achieved.                                  *
*                                                                         *
*   In this case the right hand LED is displayed dimmer than the left.    *
*   With more logic it would be possible to adjust the brightness of      *
*   individual segments within the display.                               *
*                                                                         *
**************************************************************************/

#include "mbed.h"

uint8_t left = 0;
uint8_t right = 1;

uint8_t brightness = 100;

//The 8 segment outputs and com to switch between the LEDs
DigitalOut seg_a(P1_23), seg_b(P1_28), seg_c(P0_16), seg_d(P1_31), seg_e(P1_13), seg_f(P1_16), seg_g(P1_19), seg_p(P0_23), com(P1_25);

/******************************************************
*   Set each of the segments for a desired LED        *
******************************************************/
void SetSegments(uint8_t led, uint8_t a, uint8_t b, uint8_t c, uint8_t d, uint8_t e, uint8_t f, uint8_t g, uint8_t p)
{ 
    //Set desired LED to update
    com = led;
    
    //Switch on the desired segments a number of times based on the brightness required
    for(uint8_t i = 0; i < brightness; i++) 
    {
        seg_a = 1 - a; //setting a segment to 1 means off 
        seg_b = 1 - b; //so invert all requested segment values
        seg_c = 1 - c;
        seg_d = 1 - d;
        seg_e = 1 - e;
        seg_f = 1 - f;
        seg_g = 1 - g;
        seg_p = 1 - p;
    }
    
    //Switch off all the segments a remaining number of times to reach 100 updates
    for(uint8_t i = 0; i < 100 - brightness; i++) 
    {
        seg_a = seg_b = seg_c = seg_d = seg_e = seg_f = seg_g = seg_p = 1;
    }
    
    //Finally switch off all segments again, we must do this otherwise when
    //switching com the segments could be momentarily duplicated from this led.
    seg_a = seg_b = seg_c = seg_d = seg_e = seg_f = seg_g = seg_p = 1;

}

/******************************************************
*   Main loop repeatedly updates each of the LEDs     *
******************************************************/
int main()
{
    for(;;) 
    {
        //Set the display to read '42'
        
        //The 4 will be displayed at full brightness
        brightness = 100;
        SetSegments(left,  0,1,1,0,0,1,1,0); //4
        
        //The 2 will be displayed much more faintly
        brightness = 5;
        SetSegments(right, 1,1,0,1,1,0,1,0); //2
    }
}

