/**************************************************************************
*                                                                         *
*   A stripped down simple seven segement example for RedBED              *
*                                                                         *
*   The LED block actually has 8 illuminable sections                     *
*   segments 'a' to 'g' for the main display and 'p' for a decimal point  *
*      _________                                                          *
*     <____a____>                                                         *
*   / \          / \                                                      *
*   | |          | |                                                      *
*   |f|          |b|                                                      *
*   | |          | |                                                      *
*   \ /_________ \ /                                                      *
*     <____g____>                                                         *
*   / \          / \                                                      *
*   | |          | |                                                      *
*   |e|          |c|                                                      *
*   | |          | |                                                      *
*   \ /_________ \ /                                                      *
*     <____d____>     |p|                                                 *
*                                                                         *
**************************************************************************/

#include "mbed.h"

uint8_t left = 0;
uint8_t right = 1;

//The 8 segment outputs and com to switch between the LEDs
DigitalOut seg_a(P1_23), seg_b(P1_28), seg_c(P0_16), seg_d(P1_31), seg_e(P1_13), seg_f(P1_16), seg_g(P1_19), seg_p(P0_23), com(P1_25);

/******************************************************
*   Set each of the segments for a desired LED        *
******************************************************/
void SetSegments(uint8_t led, uint8_t a, uint8_t b, uint8_t c, uint8_t d, uint8_t e, uint8_t f, uint8_t g, uint8_t p)
{
    //Set desired LED to update
    com = led;
    
    //Update the segments to the desired values.
    //the loop ensures the segments are on for an amount 
    //of time before being switched off again.
    for(uint8_t i = 0; i < 100; i++) 
    {
        seg_a = 1 - a; //setting a segment to 1 means off 
        seg_b = 1 - b; //so invert all requested segment values
        seg_c = 1 - c;
        seg_d = 1 - d;
        seg_e = 1 - e;
        seg_f = 1 - f;
        seg_g = 1 - g;
        seg_p = 1 - p;
    }
    
    //Finally switch off all segments again, we must do this otherwise when
    //switching com the segments will be momentarily duplicated from this led.
    seg_a = seg_b = seg_c = seg_d = seg_e = seg_f = seg_g = seg_p = 1;
}

/******************************************************
*   Main loop repeatedly updates each of the LEDs     *
******************************************************/
int main()
{
    for(;;) 
    {
        //Set the display to read '42'
        SetSegments(left,  0,1,1,0,0,1,1,0); //4
        SetSegments(right, 1,1,0,1,1,0,1,0); //2
    }
}

