// ----------------------------------------------------------------------------
// Copyright 2016-2017 ARM Ltd.
//
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ----------------------------------------------------------------------------

#include "mbed.h"

#include "GroveGPS.h"

Serial gps_serial(PE_8, PE_7, 9600);



//Thread gpsThread;
GroveGPS gps;
    
Semaphore parse;
Thread parsethread(osPriorityBelowNormal);


    static void parseLine() {
        while(1) {
            parse.wait();
            if (gps._last_line.find("GPGGA") != std::string::npos) {
                gps.parseGGA();
            }
            if (gps._last_line.find("GPZDA") != std::string::npos) {
                gps.parseZDA();
            }
            if (gps._last_line.find("GPVTG") != std::string::npos) {
                gps.parseVTG();
            }
            gps._last_line = "";
        }
    }


    void readCharacter(char newCharacter) {
        if (newCharacter == '\n') {
            parse.release();
        } else {
            gps._last_line += newCharacter;
        }
    }
        

void service_serial(void) {
    readCharacter(gps_serial.getc());
    }
 

int calc_cs(char * str) {
    char cs = 0;
    int x = 1;

    while(str[x] != '*') {
        cs ^= str[x++];
        }   
    return(cs);
    }
    
void nema_send( void ) {
    
    char nema_mode[] = "$PMTK314,0,0,5,5,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0*";
    char nema_cmd[64];
   int x = 0;
    sprintf( nema_cmd, "%s%x\r\n", nema_mode, calc_cs(nema_mode));
    while(nema_cmd[x]) {
        gps_serial.putc(nema_cmd[x++]);
        }
    }

int GPS_init() {
    gps._last_line = "";
   gps_serial.attach( &service_serial, Serial::RxIrq );
   gps.gps_gga.new_flag = 0;
   gps.gps_zda.new_flag = 0;
   gps.gps_vtg.new_flag = 0;
   nema_send();
   printf("\r\nGPS Init\r\n");
   parsethread.start(parseLine);
   return 0;
}