// ----------------------------------------------------------------------------
// Copyright 2016-2017 ARM Ltd.
//
// SPDX-License-Identifier: Apache-2.0
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
// ----------------------------------------------------------------------------

#include "mbed.h"

#include "GroveGPS.h"

extern int GPS_init();
extern GroveGPS gps;
Thread gpsThread(osPriorityNormal);


// Runs at 1Hz and updates the GPS location every second
void gps_updater_thread() {
    int tt, hours, minutes, seconds, tday;
    int months[] = {0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
    printf("Thread Initialized\r\n");
    while(true) {
        char latBuffer[16], lonBuffer[16];
        gps.getLatitude(latBuffer);
        gps.getLongitude(lonBuffer);

        // Utilize latitude and longitude values here
        printf("\r\nLa=%s Lo=%s\r\n", latBuffer, lonBuffer);
        tt = gps.gps_zda.utc_time;
        hours = tt / 10000;
        tt = tt - (hours*10000);
        minutes = tt / 100;
        seconds = tt - (minutes*100);
        // Correct UTC to PAcific time
        hours -= 7;
        tday = gps.gps_zda.day;
            if(hours < 0) { // UTC Correct
                hours += 24;
             tday -= 1;
             if(!tday) {
                 tday = months[gps.gps_zda.month];
                 }
            }
        printf("\r\n%02d", seconds);
        wait(1);
    }
}

int main() {
    GPS_init();
    printf("GPS Initialized\r\n");
    // Start a thread to get updated GPS values
    gpsThread.start(callback(gps_updater_thread));

    // do nothing while the library does all the work
    while (true) {

    }

    return 0;
}