#include <stdio.h>
#include <time.h>
#include <string.h>
#include <stdint.h>
#include <hash.h>
#include <assert.h>
#include <stdlib.h>
#include <stddef.h>

#define SHA1HashSize 20

int DIGITS_POWER[] = {1,10,100,1000,10000,100000,1000000,10000000,100000000};

unsigned int truncate (unsigned char *hmac, unsigned char n)
{
    uint8_t offset = hmac[SHA1HashSize-1] & 0x0f;
    unsigned int truncatedHash = 0;
    for (int i = 0; i < 4; ++i) {
        truncatedHash <<= 8;
        truncatedHash  |= hmac[offset + i];
    }
    truncatedHash &= 0x7FFFFFFF;
    truncatedHash %= DIGITS_POWER[n];
    return truncatedHash;
    
    /*uint8_t offset = hmac[SHA1HashSize-1] & 0x0f;
    long truncatedHash = (((hmac[offset] & 0x7f) << 24)
     | ((hmac[offset + 1] & 0xff) << 16)
     | ((hmac[offset + 2] & 0xff) << 8) | ((hmac[offset + 3] & 0xff)));
    truncatedHash %= DIGITS_POWER[n];
    return truncatedHash;*/
}

void strToHex(unsigned char* str, int len)
{
    for (int i = 0; i < len; i++)
      printf ("%02x", str[i] & 0xFF);
    printf ("\n");
}

int HOTP (char *key, uint64_t msg, unsigned char n)
{
    printf("Dentro do HOTP - key: %s\n", key);
    int lenKey = strlen(key);
    printf("Dentro do HOTP - lenKey: %d\n", lenKey);
    
    unsigned char counter[sizeof (msg)];
    size_t i;
    for (i = 0; i < sizeof (counter); i++)
      counter[i] = (msg >> ((sizeof (msg) - i - 1) * 8)) & 0xFF;
    
    //char hash[SHA1HashSize];
    unsigned char hash[SHA1HashSize];
    //hmac_sha1((unsigned char*)key, lenKey, counter, sizeof(msg), (unsigned char*)hash);
    hmac_sha1((unsigned char*)key, lenKey, counter, sizeof(msg), hash);
    int token = truncate(hash, n);
    strToHex(hash, SHA1HashSize);
    return token;
}

int TOTP (char *key, unsigned char n, unsigned char steps, time_t seconds)
{
    uint64_t tc = seconds/steps;
    return HOTP(key, tc, n);
}