#include "mbed.h"
#include "stdlib.h"
#include "TextLCD.h"
#include "AM2320.h"
//------------------------
#include "Adafruit_SSD1306.h"
#include "Adafruit_GFX.h" 
#include "Adafruit_GFX_Config.h"
#include "rtos.h"
//------------------------


AnalogIn    HPF(PA_0), BPF(PA_1), LPF(PA_4);
TextLCD     pantalla(PA_8,PA_9,PA_10,PB_3,PB_4,PB_5,TextLCD::LCD16x2);
Serial      pc(PB_10,PB_11);
DigitalOut  led(PC_13);
I2C         i2c(PB_9,PB_8);
AM2320      am2320(i2c);
I2CSlave    i2c2(PB_9,PB_8);

Adafruit_SSD1306_I2c oled(i2c,PB_7,0x78,64,128);

Ticker T,ticker;

InterruptIn calibrador(PA_7),calibrador2(PA_6);

////
struct PROYECT : Adafruit_GFX {
    PROYECT(int16_t x, int16_t y): Adafruit_GFX (x,y){}
};
////
void OLED();
char msg[10];
float humedad;
float temperatura,t,t2;
bool bandera=false;

void calibrar_Up(){
    bandera=true;
    if((calibrador!=0)&&(bandera==true)){
        t2++;
        bandera=false;
    }
}

void calibrar_Down(){
    bandera=true;
    if((calibrador!=0)&&(bandera==true)){
        t2--;
        bandera=false;
    }
}

void inicio(void);

uint16_t data_send_t,data_send_h;

void Sensor(){
    humedad = am2320.humidity();
    t = am2320.temperature();
    temperatura=t-t2;
        
    data_send_h = humedad;
    data_send_t = temperatura;
    pc.printf("-%d-%d-\n",data_send_t,data_send_h);
    wait_ms(200);
}

void leer(){

}

int main(){  

    
    
    inicio();
    pc.baud(115200);
  //  pc.attach(&leer,Serial::RxIrq); 
    
    calibrador.rise(&calibrar_Up);
    calibrador2.rise(&calibrar_Down);
    
    //char buf[10];
    //char msg[] = "Slave!";
    //slaveO.address(0x78);
    //slaveA.address(0xB8);
    
    
    int t=1604340235;                       /// semilla del tiempo
    set_time(t);
    
    while(1) {
        //int i = slave.receive();
        //switch (i)
  /*      pantalla.locate(0,0);
        pantalla.printf("%2.2f ",humedad/10);
        pantalla.printf("%%");
        pantalla.locate(0,1);
        pantalla.printf("%2.2f C",temperatura/10);*/
        OLED();
        Sensor();
        
        
    }
}

void OLED(){
    oled.clearDisplay();
    //   oled.printf("%s\r", ctime(&seconds));
    time_t seconds = time(NULL);
    oled.setTextCursor(10,0);
    oled.printf("%s", ctime(&seconds));
      
    oled.setTextCursor(38,17);
    oled.printf("%s"," SPI/ I2C");
       
    oled.display();
    wait_ms(16);    
}
void inicio(void){
    wait(2);
    led=!led;
    wait(1);
    pantalla.cls();
    pantalla.printf("Bienvenido");
    wait(1.5);
    pantalla.cls();
    pantalla.printf("Muestreo de I2C\ny SPI");
    wait(2.5);
    pantalla.cls();
    pantalla.printf("Sensor AM2320\nOLED y microSD");
    wait(2.5);
    led=!led;
    pantalla.cls();
}

/*

#if !DEVICE_I2CSLAVE
#error [NOT_SUPPORTED] I2C Slave is not supported
#endif

I2CSlave slave(D14, D15);

int main()
{
    char buf[10];
    char msg[] = "Slave!";

    slave.address(0xA0);
    while (1) {
        int i = slave.receive();
        switch (i) {
            case I2CSlave::ReadAddressed:
                slave.write(msg, strlen(msg) + 1); // Includes null char
                break;
            case I2CSlave::WriteGeneral:
                slave.read(buf, 10);
                printf("Read G: %s\n", buf);
                break;
            case I2CSlave::WriteAddressed:
                slave.read(buf, 10);
                printf("Read A: %s\n", buf);
                break;
        }
        for (int i = 0; i < 10; i++) {
            buf[i] = 0;    // Clear buffer
        }
    }
}*/