/**********************************
MBED1: Contains code for ->
1) Servo for Door Lock
2) JPG Camera (URL: http://mbed.org/cookbook/Camera_LS_Y201)
3) Distance Sensor
4) Lock LED / Pushbutton

Sends to Atom w/o Command:
1) BreakIn -> Signal and Pic
2) Door Open
3) Door Close
***********************************/
#include "mbed.h"
#include "Camera_LS_Y201.h"
#include "Servo.h"

Serial pc(USBTX,USBRX);
Servo servo(p21);
AnalogIn door(p20);
Camera_LS_Y201 cam(p9, p10);
DigitalOut lockLED(p11);    //1 = locked

//Pushbuttons
InterruptIn lockPB(p13);

//Globals
char signal;
int isDoorOpen;
int isDoorLocked;








/***************************************/
/*           HELPER FUNCTIONS          */
/***************************************/
inline void servoLockDoor() {servo = .5;lockLED = 1;}
inline void servoUnlockDoor() {servo = .8;lockLED = 0;}
inline void sendID() {pc.printf("1\n\r");}
inline int checkLock() {return isDoorLocked;}
inline float checkDist() {return door;}
int i;

void writePic(int done, int total, uint8_t *buf, size_t siz) {
    pc.printf("HERE\n\r");
    pc.printf((char*)buf);
}

void capture(Camera_LS_Y201 *cam1) {
    if((i=cam1->takePicture()) != 0) {
        pc.printf("ERROR TAKEPIC = %d\n\r", i);
        return;
    }
    if(cam1->readJpegFileContent(writePic) != 0) {
        pc.printf("ERROR FILECONTENT\n\r");
        return;
    }
    cam1->stopTakingPictures();
}

void lockPushed() {
    char out[50];
    if(checkLock()) {
        servoUnlockDoor();
        isDoorLocked = 0;
        sprintf(out, "USERUNLOCK\n\r");
    }
    else {
        servoLockDoor();
        isDoorLocked = 1;
        sprintf(out, "USERLOCK\n\r");
    }
    pc.printf(out);
}

void sendCurrPic() {
    pc.printf("SENDINGPIC\n\r");
    capture(&cam);
    pc.printf("PICSENT\n\r");
}

void breakIn() {
    char out[50];
    sprintf(out, "BREAKIN\n\r");
    pc.printf(out);
    sendCurrPic();
    //ADD ALARM
    while(1);
}

void lockDoor() {
    char out[50];
    if(isDoorLocked) {
        sprintf(out, "ALREADYLOCKED\n\r");
    }
    else {
        servoLockDoor();
        isDoorLocked = 1;
        sprintf(out, "NOWLOCKED\n\r");
    }
    pc.printf(out);
}

void unlockDoor() {
    char out[50];
    if(!isDoorLocked) {
        sprintf(out, "ALREADYUNLOCKED\n\r");
    }
    else {
        servoUnlockDoor();
        isDoorLocked = 0;
        sprintf(out, "NOWUNLOCKED\n\r");
    }
    pc.printf(out);
}

void sendCheckLock() {
    char out[50];
    sprintf(out,"LOCK:%d\n\r", checkLock());
    pc.printf(out);
}

void sendCheckDist() {
    char out[50];
    sprintf(out,"DIST:%0.3f\n\r", checkDist());
    pc.printf(out);
}

void sendFullStatus() {
    char out[50];
    sprintf(out,"LOCK:%d|DIST:%0.3f\n\r", checkLock(), checkDist());
    pc.printf(out);
}

void getMessage() {
    //Check for Message
    signal = pc.getc();
    
    //Switch on Buffer
    switch(signal) {
        case 'o':
            sendID();
            break;
        case 'p':
            sendFullStatus();
            break;
        case 'q':
            sendCheckDist();
            break;
        case 'w':
            sendCheckLock();
            break;
        case 's':
            lockDoor();
            break;
        case 'x':
            unlockDoor();
            break;
        case 't':
            sendCurrPic();
            break;
        default:
            pc.printf("BADCOMMAND\n\r");
            break;
    }
}










/***************************************/
/*                MAIN                 */
/***************************************/
int main() {
    //Variables
    int DOOR_DISTANCE = door + .05;

    //Setup
    lockLED = 1;
    isDoorLocked = 1;
    servo = .5;
    
    //Setup for freopen
    pc.baud(9600);
    pc.attach(&getMessage);
    pc.printf("It is connected\n\r");
    
    //Setup Interrupts
    lockPB.mode(PullUp);
    wait(0.1);
    lockPB.fall(&lockPushed);
    
    //Camera
    wait(1);
    pc.printf("Reseting Camera...\n\r");
    if(cam.reset() != 0) {
        pc.printf("RESET ERROR\n\r");
        return 1;
    }
    wait(1);
        
    while(1);// {
   /* 
        //Check Door Dist and Send if needed
        if(isDoorOpen) {
            if(door < DOOR_DISTANCE) {
                isDoorOpen = 0;
                pc.printf("DOORCLOSE\n\r");
            }
        }
        else {
            if(door > DOOR_DISTANCE) {
                isDoorOpen = 1;
                if(isDoorLocked) {
                    breakIn(); //Break In!
                }
                else {
                    pc.printf("DOOROPEN\n\r");
                }
            }
        }
        wait_ms(50);
        */
    //} // End While(1)
}