// Morse Code Machine      February 27, 2013

#include "mbed.h"
#include "MorseCode.h"

//Need to Setup LCD Screen as TextLCD lcd(p15, p16, p17, p18, p19, p20) - Is included in MorseCode.cpp
DigitalIn Button(p8); // Button for User to Input Morse Code
DigitalOut LED(LED1); // LED to Indicate Time (every 1 seconds)
PwmOut Speaker(p21); // Speaker to play noise when button pushed
Timer Time; // Keeps track of time

int main() {
    // Setup
    int up = 0;
    int read = 0;
    Button.mode(PullUp);
    Speaker.period(1.0/800.0);
    Time.start();
    
    //Start
    while(1) {
    
        //Timer For User Comfort
        if(Time.read_ms()%1000<15) { 
            up = !up;
            read = 0;       // Reset for Next Second
            if((Time.read_ms() - 1740000) > 0) {
                Time.reset(); // Reset if more than 29 minutes.
            }
            wait_ms(15);
        }
        
        // LED Ticker
        LED = (up)? 1 : 0;
        
        // Audio
        if(!Button) {
            Speaker = 0.25; // Volume
            wait_ms(15);
        }
        else {
            Speaker = 0.0; //Mute
            wait_ms(15);
        }
        
        // Do Morse Code  
        if(Time.read_ms()%1000 > 500 && read == 0) { // Half a Second Has Passed
            read = 1;
            MorseCode(!Button); // Read Button Value
        }
        
    }// End While
}
