//Morse Code Source File

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p15, p16, p17, p18, p19, p20); // LED screen to display text as it is typed

int Value = 0;
int First = 1;
int ThreeZeros = 0;
int SevenZeros = 0;
int TenZeros = 0;

void printChar(int val) {
    switch(val) {
    case 0: // Printing 0 does nothing
        break;
    case 184:
        lcd.putc('a');
        break;
    case 3752:
        lcd.putc('b');
        break;
    case 15080:
        lcd.putc('c');
        break;
    case 936:
        lcd.putc('d');
        break;
    case 8:
        lcd.putc('e');
        break;
    case 2792:
        lcd.putc('f');
        break;
    case 3816:
        lcd.putc('g');
        break;
    case 680:
        lcd.putc('h');
        break;
    case 40:
        lcd.putc('i');
        break;
    case 48056:
        lcd.putc('j');
        break;
    case 3768:
        lcd.putc('k');
        break;
    case 2984:
        lcd.putc('l');
        break;
    case 952:
        lcd.putc('m');
        break;
    case 232:
        lcd.putc('n');
        break;
    case 15288:
        lcd.putc('o');
        break;
    case 12008:
        lcd.putc('p');
        break;
    case 61112:
        lcd.putc('q');
        break;
    case 744:
        lcd.putc('r');
        break;
    case 168:
        lcd.putc('s');
        break;
    case 56:
        lcd.putc('t');
        break;
    case 696:
        lcd.putc('u');
        break;
    case 2744:
        lcd.putc('v');
        break;
    case 3000:
        lcd.putc('w');
        break;
    case 15032:
        lcd.putc('x');
        break;
    case 60344:
        lcd.putc('y');
        break;
    case 15272:
        lcd.putc('z');
        break;
    }
}

void MorseCode(int tick) {
    if(tick) {
        ThreeZeros = 0;
        SevenZeros = 0;
        TenZeros = 0;
        
        //Update Value with a 1
        Value = Value << 1;
        Value += 1;
    }
    else {
        ThreeZeros += 1;
        SevenZeros += 1;
        TenZeros += 1;
        
        //Update Value with a Zero
        Value = Value << 1;
    }
    
    if(First) {
        lcd.cls();
        First = 0;
    }
    
    // Print Char if three zeros in a row
    if(ThreeZeros == 3) {
        printChar(Value);
        ThreeZeros = 0;
        Value = 0;
    }
    if(SevenZeros == 7) { // Space
        lcd.putc(' ');
        SevenZeros = 0;
    }
    if(TenZeros == 10) { // Clear
        lcd.cls();
        SevenZeros = 0;
        TenZeros = 0;
    }
}