#include "mbed.h"
#define ON 0        //definimos on y off
#define OFF 1
DigitalOut led_G(LED_GREEN);  //definimos leds   verde, azul y rojo
DigitalOut led_R(LED_RED);
DigitalOut led_B(LED_BLUE);

Serial pc(USBTX, USBRX); // tx, rx   comunicacion serial

InterruptIn button2(SW2);//PTC6     CAMBIO
InterruptIn button3(SW3);//PTA4      PARO

PwmOut motor(PTC10); //PTC10
DigitalOut F_R(PTC11); //PTC11

AnalogIn   ain(A0);

Ticker flipper;

enum color {NEGRO,ROJO,VERDE,AMBAR,AZUL,MAGENTA,CYAN,BLANCO};  // enumeramos los colores

void led_RGB(color i);
void Control_Led();


float p=0;
int B_Print=0;
int B_Pulso=0;
int B_Enc_Apg=0;
int Color_Final=NEGRO;

void Led_RGB_Control();
void Manda_PWM();
void paro();
void cambio();
void imprime();

int main()
{
    F_R=0;
    button2.fall(&cambio);  // cuando oprimes el boton hay un paro
    button3.fall(&paro);  // cuando oprimes el boton3 hara cambio degiro

    flipper.attach(&Control_Led, 0.5);  //Ticker pata el color ambar
    pc.printf("Motor Apagado \n\r");
    Color_Final=AZUL;  //asegurar el color azul


    while(1) {           // wait around, interrupts will interrupt this!

        Manda_PWM();

    }
}


void imprime()
{
  //  static float last_p;
  //  if(abs(p-last_p)>=0.1f)
        p=ain.read();
        printf("percentage: %3.3f%%\n\r", p*100.0f);
        wait(0.1f);
   // last_p=p;
    // pc.printf("El motor esta apagado \n\r");

}



void Manda_PWM()                         //asigna el valor de p a la salida
{

    p=ain.read();
    if(B_Enc_Apg) {
        imprime();

        if(p>=0.95f) {
            p=1;
            Color_Final=ROJO;
        }

        if(p<=0.05f) {
            p=0;
            Color_Final=AZUL;
        }
    }
    else p=0;
    motor=p;
}



void cambio()                         //SW2
{

    F_R=!F_R;
    B_Pulso = 1;

}

void paro( )  //sw3
{
    B_Enc_Apg=! B_Enc_Apg;
    B_Pulso = 1;

}



void led_RGB(color i)
{
    enum {RED=1,GREEN=2,BLUE=4};

    if(i&RED) led_R= ON;
    else led_R=OFF;
    if(i&GREEN) led_G= ON;
    else led_G=OFF;
    if(i&BLUE) led_B= ON;
    else led_B=OFF;

}
void Control_Led(void)
{
    if (B_Pulso) {
        led_RGB(AMBAR);
        B_Pulso=0;
    } else
        led_RGB((color) Color_Final);
}