
#include "serial.h"
#include "mbed.h"
#include "robotarm.h"

#define ENABLE_BLUETOOTH 1
#define ENABLE_PC_SERIAL 1
#define COMMAND_MESSAGE_BYTE 0X1D

#define PC_BAUD 115200
#define BLUETOOTH_BAUD 115200

Serial bt(p13, p14);

int turning = 1;

char pc_command_message_started = 0;
char pc_command_message_byte = 0;
char pc_command_message[3];

char bt_command_message_started = 0;
char bt_command_message_byte = 0;
char bt_command_message[3];

char file_transfer_mode = 0;
Timeout pc_command_timeout;
Timeout bt_command_timeout;

void SerialControl::setup_serial_interfaces()
{
    if(ENABLE_PC_SERIAL) {
        pc.baud(PC_BAUD);
        pc.attach(this,&SerialControl::IF_pc_rx_callback, Serial::RxIrq);
    }
    if(ENABLE_BLUETOOTH) {
        bt.baud(BLUETOOTH_BAUD);
        bt.attach(this,&SerialControl::IF_bt_rx_callback, Serial::RxIrq);
    }
}
    
void SerialControl::IF_handle_command_serial_message(char message[3], char interface){
    if(message[0]==1){
        turning = 1;
        pc.printf("start turn(beacon on)%d\n",turning);
    }
    else if(message[1]==1){
        pc.printf("stop turn(beacon on)%d\n", turning);
        turning = 0;
    }
    else if(message[2]==1){
        pc.printf("beacon off\n");
        turning = 2;
    }
    else if(message[0] == 2){
        bt.printf("%c%d",COMMAND_MESSAGE_BYTE, turning);
        pc.printf("%c%d", COMMAND_MESSAGE_BYTE, turning);
    }
}


Timeout bt_message_timeout;
//static float bt_message_timeout_period = 0.001; // 1 millisecond
char bt_buffer[255];
int bt_buffer_index = 0;

void SerialControl::IF_bt_message_timeout()
{
    char buffer[255];

    sprintf(buffer, bt_buffer, bt_buffer_index);
    buffer[bt_buffer_index] = 0;
    if(file_transfer_mode == 1) {
    } else {
//    debug("BT message timeout: %s [%d chars]\n", buffer, bt_buffer_index);
        if(bt_buffer_index == 5 && buffer[0] == COMMAND_MESSAGE_BYTE && buffer[4] == COMMAND_MESSAGE_BYTE) {
            bt_command_message[0] = buffer[1];
            bt_command_message[1] = buffer[2];
            bt_command_message[2] = buffer[3];
            IF_handle_command_serial_message(bt_command_message , 1);
        } 
    }
    bt_buffer_index = 0;
}


void SerialControl::IF_bt_rx_callback()
{
    int count = 0;
    char message_array[255];

    wait_ms(500); // Wait 0.5ms to allow a complete message to arrive before atttempting to process it

    while(bt.readable()) {
        char tc = bt.getc();
        message_array[count] = tc;
        count ++;
        if(bt_command_message_started == 1) {
            if(bt_command_message_byte == 3) {
                bt_command_timeout.detach();
                if(tc == COMMAND_MESSAGE_BYTE) {
                    // A complete command message succesfully received, call handler
                    bt_command_message_started = 0;
                    count = 0;
                    IF_handle_command_serial_message(bt_command_message , 1);
                } else {
                    // Message is not a valid command message as 5th byte is not correct; treat whole message as a user message
                    bt_command_message_started = 0;
                    message_array[0] = COMMAND_MESSAGE_BYTE;
                    message_array[1] = bt_command_message[0];
                    message_array[2] = bt_command_message[1];
                    message_array[3] = bt_command_message[2];
                    message_array[4] = tc;
                    count = 5;
                }
            } else {

                bt_command_message[bt_command_message_byte] = tc;
                bt_command_message_byte ++;
            }
        } else {
            if(count == 1) {
                if(tc == COMMAND_MESSAGE_BYTE) {
                    bt_command_message_started = 1;
                    bt_command_message_byte = 0;

                }
            }
        }
    }
}

void SerialControl::IF_pc_rx_callback()
{
    int count = 0;
    char message_array[255];

    while(pc.readable()) {
        char tc = pc.getc();
        message_array[count] = tc;
        count ++;
        if(pc_command_message_started == 1) {
            if(pc_command_message_byte == 3) {
                pc_command_timeout.detach();
                if(tc == COMMAND_MESSAGE_BYTE) {
                    // A complete command message succesfully received, call handler
                    pc_command_message_started = 0;
                    count = 0;
                    IF_handle_command_serial_message(pc_command_message , 0);
                } else {
                    // Message is not a valid command message as 5th byte is not correct; treat whole message as a user message
                    pc_command_message_started = 0;
                    message_array[0] = COMMAND_MESSAGE_BYTE;
                    message_array[1] = pc_command_message[0];
                    message_array[2] = pc_command_message[1];
                    message_array[3] = pc_command_message[2];
                    message_array[4] = tc;
                    count = 5;
                }
            } else {
                pc_command_message[pc_command_message_byte] = tc;
                pc_command_message_byte ++;
            }
        } else {
            if(count == 1) {
                if(tc == COMMAND_MESSAGE_BYTE) {
                    pc_command_message_started = 1;
                    pc_command_message_byte = 0;

                }
            }
        }
    }
}