#include "robotarm.h"
#include <math.h>
#include "serial.h"
#define ON 1
#define OFF 0

Robotarm arm;
DigitalOut beacon(p15);
SerialControl serial;


int main()
{   
    
    int base_degree = 90;    
    int flag = 1;
    
    //Run the main initialisation routine
    arm.init();  
    serial.setup_serial_interfaces();
    /* Set all servos speed to 0.1 */
    servo.SetCRSpeed( BASE , 0.1 );
    servo.SetCRSpeed( SHOULDER , 0.1 );
    servo.SetCRSpeed( ELBOW , 0.1 );
    
    //Reset the servos to center position (after 1 second delay)
    //NB This activates the servos (makes rigid) so be careful when using
    arm.zero_servos(1);
    //Wait till servos are zeroed
    wait(3);
    display.clear_display();
    display.set_position(0,0);
    display.write_string("start"); 
    servo.SetGoalDegrees( BASE , 0 , 1);
    servo.SetGoalDegrees( SHOULDER , 0 , 1 );
    servo.SetGoalDegrees( ELBOW , 90 , 1 );
    while(1){
        if(turning == 1){
            beacon = ON;
            if(flag == 1){
                if(base_degree >= 180){
                   flag = 0;
                }
                else {
                    base_degree += 5;
                }
            }
            else if(flag == 0){
                if(base_degree <= 0){
                    flag = 1;
                }
                else {
                    base_degree -= 5;
                }
            }
            servo.SetGoalDegrees( BASE , base_degree-90 , 1);
        }
        else if(turning == 0){
           // turning = 3;
            beacon = ON;
            servo.SetGoalDegrees( BASE , base_degree - 90 , 1);
            pc.printf("base_degree = %d \n", base_degree - 90);
        }
        else if(turning == 2){
            beacon = OFF;
            servo.SetGoalDegrees( BASE , 0 , 1);
            base_degree = 90;
            wait(0.5);
        }
    }
  
}

   


