#include "mbed.h"
#include "LAS_TB.h"

LAS_TB::LAS_TB(PinName PinTX, PinName PinRX) : SerialPort(PinTX,PinRX)
{
    //constructor.
    SerialPort.baud(115200);
    SerialPort.attach(callback(this,&LAS_TB::Rx_interrupt), Serial::RxIrq);
    
    //Dit verzenden we naar de LAS-TB. Bevat het order get measured....
    Stack[0] = 0x55;    //Sync byte.
    Stack[1] = 0x08;    //Order (Get measerued values from L-LAS-RAM.)
    Stack[2] = 0x00;    //ARG LO.
    Stack[3] = 0x00;    //ARG HI.
    Stack[4] = 0x00;    //LEN LO.
    Stack[5] = 0x00;    //LEN HI.
    Stack[6] = 0xAA;    //CRC8 HEAD.
    Stack[7] = 0x76;    //CRC8 DATA.
}

union Converter
{
    int32_t um;     // occupies 4 bytes
    uint8_t byteArray[4]; // occupies 4 bytes
}; 

//Vragen om een meting.
void LAS_TB::MeasurementRequest()
{
    SendStack();
}

//Wordt uitgevoerd bij ontvangen bericht.
void LAS_TB::Rx_interrupt()
{
    while (SerialPort.readable())
    {
        for (int i = 0; i < 71; i++)
        {
            ReceivedStack[i] = ReceivedStack[i+1];
        }
        ReceivedStack[71] = SerialPort.getc();
        
        //Hoe weten we dat het bericht goed is?
        if (ReceivedStack[0] == 0x55 && ReceivedStack[1] == 0x08 && ReceivedStack[4] == 64)
        {
            int32_t temp = ReceivedStack[16];
            
            umvalue = temp << 24;
            temp = ReceivedStack[17];
            umvalue += temp << 16;
            temp = ReceivedStack[18];
            umvalue += temp << 8;
            temp = ReceivedStack[19];
            umvalue += temp;       
        }
    }
}

//Het sturen van data.
//Sends the stack of data to the sensor module.
void LAS_TB::SendStack()
{
        
    for (int i = 0; i < 10; i++)
    {
        SerialPort.putc(Stack[i]);
    }
    
}